      $set vsc2 preprocess(window1)
      *
      * @(#)mfwcalc.cbl	1.1
      ************************************************************************
      * Copyright (C) 1998-1999 Micro Focus International Ltd.
      * All rights reserved.
      *  
      * This demonstration program is provided for use by users of 
      * Micro Focus products (the "Software") and may be used, 
      * modified and distributed as part of your application provided 
      * that you properly acknowledge the copyright of Micro Focus in this
      * material.
      *     
      * All conditions, warranties and undertakings, express or implied, 
      * statutory or otherwise, on the part of Micro Focus are excluded, 
      * including without limitation those of merchantability or fitness  
      * for purpose. This shall not, however, purport to exclude or 
      * restrict the liability of Micro Focus to any extent not 
      * permitted by law.
      *
      * IN NO EVENT WILL MICRO FOCUS BE LIABLE FOR ANY INDIRECT, 
      * INCIDENTAL, SPECIAL, CONSEQUENTIAL OR OTHER DAMAGES ARISING OUT 
      * OF THE USE OF THE DEMONSTRATION PROGRAM DISTRIBUTED WITH THE 
      * SOFTWARE, WHETHER OR NOT INFORMED OF THE POSSIBILITIES OF 
      * DAMAGES IN ADVANCE.  THESE LIMITATIONS APPLY TO ALL CAUSES OF 
      * ACTION, INCLUDING BREACH OF CONTRACT, BREACH OF WARRANTY, STRICT
      * LIABILITY, AND ANY ACTIONS IN TORTS.
      ************************************************************************

       identification division.
       program-id. mfwcalc.
       environment division.

      ******************************************************************
      *                                                                *
      * This example program provides a simple pop-up calculator  that *
      * can be called from either the command line or from an applica- *
      * tion  program.  The last calculated result is returned to  the *
      * calling program if appropriate.                                *
      *                                                                *
      * The program demonstrates the following points:                 *
      *   1 Windowing syntax                                           *
      *   2 Screen Section syntax                                      *
      *   3 Setting Escape and data keys as function keys              *
      *   4 How to determine if called with parameters                 *
      *   5 Figurative constants to give easier maintenance            *
      *                                                                *
      ******************************************************************

       special-names.
           crt status is crt-status.
       working-storage section.

      ******************************************************************
      *                                                                *
      * Note how the calculator function keys are set up as figurative *
      * constants by using level 78.  This enables the key  characters *
      * to be specified in one place only so that changing one of them *
      * to a different value during maintenance becomes trivial.   The *
      * figurative  constant  is used in the level 88  value  for  the *
      * status  key, the value to be displayed in the  screen  section *
      * display item and also in the procedure division when  evaluat- *
      * ing which key has been pressed.                                *
      *                                                                *
      ******************************************************************

       78  screen-handling		value x"af".
       78  enable-data-key		value 1.
       78  normal-data-key		value 2.
       78  key-exit                     value x"00".
       78  key-add			value "+".
       78  key-minus			value "-".
       78  key-div			value "/".
       78  key-mult			value "*".
       78  key-equal			value "=".
       78  key-clear			value "C".
       78  key-clear2			value "c".

       77  input-number			pic s9(9)v9(6).
       77  total			pic s9(9)v9(6).
       77  calc-window                  pic x(10).
       77  current-function		pic x		value space.
           88  exit-pressed		value key-exit.
           88  add-pressed		value key-add.
           88  minus-pressed		value key-minus.
           88  div-pressed		value key-equal.
           88  mult-pressed		value key-mult.
           88  equal-pressed		value key-equal.
           88  clear-pressed		value key-clear key-clear2.

       01  crt-status.
        03 crt-stat1			pic x.
        03 crt-stat2			pic x.
        03 filler			pic x.

       01  set-data-keys		pic 9(2) comp-x value 1.
       01  data-key-control.
        03 data-key-setting		pic 9(2) comp-x.
        03 data-or-function-key		pic x.
        78 function-selected		value "1".
        78 data-selected		value "3".
        03 data-key-value		pic x.
        03 filler			pic 9(2) comp-x value 1.

       linkage section.
       01  os-parameter			pic 9(4) comp.
       01  returned-number              pic -(9)9.9(6).

       screen section.

       01  input-data highlight.
        03      value "  " line 2 column 4.
        03      pic -(9)9.9(6) using input-number prompt space.
        03      value "  ".
      
       01  key-layout.
        03      line 4 column 6 value "1    2    3    ".
        03 	value key-add.
        03      line 5 column 6 value "4    5    6    ".
        03 	value key-minus.
        03      line 6 column 6 value "7    8    9    ".
        03 	value key-mult.
        03      line 7 column 6 value key-clear.
        03      value                  "    0    ".
        03 	value key-equal.
        03      value                            "    ".
        03 	value key-div.

       procedure division using os-parameter returned-number.
       a000-control section.
           perform b000-initialize
           perform c000-calculate with test after until exit-pressed
           perform d000-tidy-up.
       a999.

      ******************************************************************
      *                                                                *
      * Note  that  if this program has been called from  the  command *
      * line,  then  there will only be one parameter in  the  linkage *
      * section  (which contains the size and contents of the  command *
      * line).   If there is a second parameter, then the program  has *
      * been called by another program which expects the second param- *
      * eter to be set to the last calculated result prior to the EXIT *
      * PROGRAM statement.                                             *
      *                                                                *
      * We check whether the second parameter is present by seeing  if *
      * it  has been set to a valid address (ie. not equal to  a  NULL *
      * value).  This technique can easily be extended to discover how *
      * many  parameters were used by the calling program by  checking *
      * the address of each parameter, starting from the rightmost one *
      * and working to the left.  All valid parameters will have  non- *
      * NULL addresses.                                                *
      *                                                                *
      ******************************************************************

           if address of returned-number not = null
           	move total to returned-number
           end-if
           exit program
           stop run.


       b000-initialize section.

           initialize input-number total current-function

           display window, line 8, column 23, size 27, lines 8,
                   boxed, erase,
                   bottom right title "Press Esc to exit"
                   pop-up area is calc-window.

           display box, line 1, column 3, size 23, lines 3.

           display key-layout

           move enable-data-key to data-key-setting
           perform e000-handle-data-keys.
           

       c000-calculate section.
           perform g000-compute with test after
				until equal-pressed or exit-pressed
           perform h000-give-answer.


       d000-tidy-up section.
           move normal-data-key to data-key-setting
           perform e000-handle-data-keys.
           close window calc-window.


       e000-handle-data-keys section.
           move function-selected to data-or-function-key
           move key-exit to data-key-value
           perform f000-one-data-key
           move data-selected to data-or-function-key
           move key-add to data-key-value
           perform f000-one-data-key
           move key-minus to data-key-value
           perform f000-one-data-key
           move key-div to data-key-value
           perform f000-one-data-key
           move key-mult to data-key-value
           perform f000-one-data-key
           move key-equal to data-key-value
           perform f000-one-data-key
           move key-clear to data-key-value
           perform f000-one-data-key
           move key-clear2 to data-key-value
           perform f000-one-data-key.


       f000-one-data-key section.
      ******************************************************************
      *                                                                *
      * This routine enables or disables function keys.  Actual  func- *
      * tion  keys  (including  the Escape key) can  be  specified  or *
      * ordinary  data keys can be used as function keys  that  return *
      * control  to  the  program from an active  full  screen  ACCEPT *
      * statement.                                                     *
      *                                                                *
      ******************************************************************
           call screen-handling using set-data-keys data-key-control.


       g000-compute section.
           display input-data 
           accept  input-data 

           evaluate current-function
           when key-add
		add input-number to total
           when key-minus
		subtract input-number from total
           when key-div
		divide input-number into total
           when key-mult
		multiply input-number by total
           when other
		move input-number to total
           end-evaluate
           move space to current-function
           evaluate crt-stat1
           when "1"
		evaluate crt-stat2
		when key-exit
		    move crt-stat2 to current-function
           end-evaluate
           when "3"
           	evaluate crt-stat2
		when key-clear
		when key-clear2
		    move zero to total
		    move key-equal to current-function
		when key-add
		when key-minus
		when key-div
		when key-mult
		when key-equal
		    move crt-stat2 to current-function
           end-evaluate
           move zero to input-number.


        h000-give-answer section.
            move total to input-number.
