/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.cobol.runtimeservices.servlet;

import com.microfocus.cobol.runtimeservices.IRunUnit;
import com.microfocus.cobol.runtimeservices.IRunUnitManager;
import com.microfocus.cobol.runtimeservices.RunUnitManager;
import com.microfocus.cobol.runtimeservices.RunUnitStartupOptions;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;

public class ServletRunUnitManager
implements IRunUnitManager<HttpSession> {
    public static final String BINDING_NAME = "_MF_RUN_UNIT_BINDING";
    private static final RunUnitStartupOptions options = RunUnitStartupOptions.UseSingleThreadedRuntime;
    private final RunUnitManager<String> stringManager = new RunUnitManager();
    private static final ServletRunUnitManager staticManager = new ServletRunUnitManager();

    private ServletRunUnitManager() {
    }

    @Override
    public IRunUnit GetSessionRunUnit(HttpSession sessionObject) {
        boolean setupBinding = !this.SessionRegistered(sessionObject);
        IRunUnit runUnit = this.stringManager.GetSessionRunUnit(sessionObject.getId(), options);
        if (setupBinding) {
            sessionObject.setAttribute(BINDING_NAME, (Object)new RunUnitSessionBinding());
        }
        return runUnit;
    }

    @Override
    public void EndSession(HttpSession sessionObject) {
        this.EndSession(sessionObject, 0);
    }

    @Override
    public void EndSession(HttpSession sessionObject, int returnCode) {
        this.stringManager.EndSession(sessionObject.getId(), returnCode);
    }

    @Override
    public boolean SessionRegistered(HttpSession sessionObject) {
        return this.stringManager.SessionRegistered(sessionObject.getId());
    }

    public static ServletRunUnitManager getManager() {
        return staticManager;
    }

    private static class RunUnitSessionBinding
    implements HttpSessionBindingListener {
        private RunUnitSessionBinding() {
        }

        public void valueBound(HttpSessionBindingEvent arg0) {
        }

        public void valueUnbound(HttpSessionBindingEvent arg0) {
            staticManager.EndSession(arg0.getSession());
        }
    }
}

