#
# Script for creating oracle-enabled run-time and callable shared object
# @(#)makeorarts 1.43
#

# Ensure that COBDIR is setup. Determine whether we're using OCDS or SX.

if test x.$COBDIR = x.
then
	echo "You must have a COBOL environment set up before proceeding."
	exit 1
fi

if test x.$ORACLE_HOME = x.
then
	echo "You must have an Oracle environment set up before proceeding."
	exit 1
fi

if test -d $COBDIR/etc
then
	cob_type=sx
	if test -f $COBDIR/bin/cobmode
	then
		cob_mode=`cobmode | awk '{print $5}'`
	else
		if test x.$COBMODE = x.64 -o ! -d $COBDIR/dynload
		then
			cob_mode=64
		else
			cob_mode=32
		fi
	fi
else
	cob_type=ocds
	cob_mode=32
fi

case `uname -sm` in
"HP-UX 9000/800")	SO_EXT=.sl;;
*)	SO_EXT=.so;;
esac

rm -f rtsora*

# Establish Oracle version, as Oracle 8 and Oracle 9 work differently
# (as does Oracle 8.0 and Oracle 8i).

if test $cob_mode = 32
then
	if test -f $ORACLE_HOME/bin/procob32 -a -f $ORACLE_HOME/bin/procob
	then
		ora_ver=`procob32 | fgrep Release | awk '{print $3}'`
	else
		ora_ver=`procob | fgrep Release | awk '{print $3}'`
	fi
else
	if test -f $ORACLE_HOME/bin/procob -a -f $ORACLE_HOME/bin/procob64
	then
		ora_ver=`procob64 | fgrep Release | awk '{print $3}'`
	else
		ora_ver=`procob | fgrep Release | awk '{print $3}'`
	fi
fi

case $ora_ver in 

8.*)
	sed -e "s!^\(include \).*/env!\1./env!" < $ORACLE_HOME/precomp/lib/ins_precomp.mk > ins_precomp.mk
	if test $cob_type = sx
	then
		sed -e "s!-xe!-z,sys,nounload -e!" < $ORACLE_HOME/precomp/lib/env_precomp.mk > env_precomp.mk
		case $ora_ver in
		8.1.6|8.1.7*)
			make LOC_RTSORA=rtsora_t$SO_EXT -f ins_precomp.mk rtsora_t$SO_EXT
			;;
		*)
			make RTSORA=./rtsora -f ins_precomp.mk ./rtsora
			mv rtsora rtsora_t$SO_EXT
			;;
		esac
	fi
	cp $ORACLE_HOME/precomp/lib/env_precomp.mk .
	make RTSORA=rtsora LOC_RTSORA=rtsora -f ins_precomp.mk rtsora
	rm -f ???_precomp.mk
	;;

*)

	case $cob_mode in
	32)
		if test -d $ORACLE_HOME/lib32
		then
			libdir=lib32
		else
			libdir=lib
		fi
		;;

	64)
		libdir=lib
		;;
	esac


	# Determine the correct link flags to use

	case `uname -sm` in
	"HP-UX 9000/800")
		# Build flags for PA-RISC running HP-UX
		COBFLAGS="`cat $ORACLE_HOME/$libdir/ldflags`   `cat $ORACLE_HOME/$libdir/sysliblist`  -lm  -lpthread"
		;;
	"HP-UX ia64")
		# Build flags for Itanium running HP-UX
		COBFLAGS="`cat $ORACLE_HOME/$libdir/ldflags`   `cat $ORACLE_HOME/$libdir/sysliblist`  -lm"
		;;
	*)

		# All non-HP PA-RISC platforms

		case `uname -sp` in
		"AIX powerpc")
		# Build flags for pSeries running AIX
			COBFLAGS="-lld -lm `cat $ORACLE_HOME/$libdir/sysliblist`  -lm  -lc_r -lpthreads"
			;;
		"SunOS sparc")
		# Build flags for SPARC running Solaris
			COBFLAGS="`cat $ORACLE_HOME/$libdir/ldflags`   `cat $ORACLE_HOME/$libdir/sysliblist` -laio  -lposix4  -lm  -lthread"
			;;
		"Linux i686"|"Linux s390")
		# Build flags for x86 and zSeries running Linux
			COBFLAGS="`cat $ORACLE_HOME/$libdir/ldflags`   `cat $ORACLE_HOME/$libdir/sysliblist` -ldl -lm  "
			;;
		esac
		;;
	esac

	# Now create the callable shared object and executable

	cob -z,sys,nounload -to rtsora_t$SO_EXT -e "" -L/bin/unix -L$ORACLE_HOME/$libdir/ $ORACLE_HOME/precomp/$libdir/cobsqlintf.o -lclntsh $COBFLAGS
	cob -xto rtsora$cob_mode -e "" -L/bin/unix -L$ORACLE_HOME/$libdir/ $ORACLE_HOME/precomp/$libdir/cobsqlintf.o -lclntsh $COBFLAGS

esac
rm -f ???_precomp.mk
