      $set sourceformat "free"
      $set repository(update ON) preservecase case
       *>***h* functions/fnztrim
       *> NAME
       *>  fnztrim
       *> FUNCTION
       *>  suppress spaces at the beginning of the string and puts a x'00' 
       *>  immdiately after le last non white character of the string
       *> USAGE
       *>  move fnztrim(string) to myString
       *> INPUTS
       *>  a string 
       *> OUTPUT
       *>  a string
       *> USES
       *>  
       *> USED BY
       *>  
       *> HISTORY
       *>  04/05/2020 : creation
       *> SOURCE
       identification division.
       function-id. fnztrim.
       environment division.
       78 MaxSize value 32000.
       1 wss-x32k pic x(MaxSize).
       1 wss-i7-length pic 9(7).
       1 wss-stringx pic x(MaxSize).
       1 tally-count pic 9(7).
       linkage section.
       1 lnk-str pic x any length.
       1 lnk-stringout pic x(MaxSize).
       procedure division using lnk-str returning lnk-stringout.
            move spaces to wss-stringx
            move lnk-str to wss-stringx
            move zero to tally-count
            inspect function reverse(wss-stringx)
              tallying tally-count
              for leading spaces
            if tally-count > 0 then
             move low-values to wss-stringx(MaxSize - tally-count + 1 : tally-count)
            else
             move x'00' to wss-stringx(MaxSize:1)
            end-if
            move wss-stringx to lnk-stringout
            goback.
       *>**
