/* The C language comes with a regular expression engine as standard and
a header file in regex.h. In this example program, we ask the user to
enter a regular expression and then match it against a series of further
strings.

There is a shorter example at reg.c ... this example (reg2.c) caputures
the start and end point of each match and then prints out the string that
matches that part of the incoming string- "capture parenthises" */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <regex.h>

#define MAXMATCH 20

int regex ( char *reginald, /* Regular Expresion */
            char *millie,   /* Strings to match against */
            char *tommy)    /* String to hold matched elememts */
{

        regex_t emma;
        regmatch_t matches[MAXMATCH]; /* Array of matches */
        int status;
        int return_status;
        int i;
        int numchars;

        /* Let's use extended regular expresssions */

        status = regcomp(&emma,reginald,REG_EXTENDED);
        // printf("Validity of regex (0 => OK): %d\n",status);

        /* Leave program if regex is faulty */
        /* we could use regerror to decode the error ... */
        if (status) return 0;
        if (strlen(millie) < 1) return 0;
        return_status = 0 ;
        status = regexec(&emma,millie,MAXMATCH,matches,0);
        // printf("Matched (0 => Yes): %d\n",status);
        if (status == 0) {
          for (i=0; i<MAXMATCH; i++) {
            if ((int)matches[i].rm_so < 0) break;
            numchars = (int)matches[i].rm_eo - (int)matches[i].rm_so;
            strncpy(tommy,millie+matches[i].rm_so,numchars);
            tommy[numchars] = '\0';
            return_status = (int)matches[i].rm_so;
            //printf("From %d to %d (%s)\n",(int)matches[i].rm_so, (int)matches[i].rm_eo,tommy);
          }
        }

        /* Free up memory held within the regex memory */
        regfree(&emma);

        return return_status;
}
