      $set repository(update ON) preservecase case
      $set sourceformat "free" 
       *>***h* fnemailcheckwithregex
       *> name
       *>  fnemailcheckwithregex
       *> function
       *>  check if email is valid
       *> usage
       *>  
       *> inputs
       *>  lnk-mail-id : email to check
       *>   
       *> output
       *>  pic 9 value 1 if valid mail, 0 if invalid mail
       *>
       *> uses
       *>
       *> history
       *>  08/04/2020 : creation
       *>
       *> comment
       *>  There is a length limit on email addresses. 
       *>  That limit is a maximum of 64 characters (octets) in the "local part" (before the "@") 
       *>  and a maximum of 255 characters (octets) in the domain part (after the "@") 
       *>  for a total length of 320 characters.
       *>**
       identification division.
       function-id. fnemailcheckwithregex.
       environment division.
       repository.
         function fnztrim.

       data division.
       working-storage section.
       1 wss-x255-regex        pic x(255). *> Regular Expresion
       1 wss-x320-strToMatch    pic x(321). *> Strings to match against 
       1 wss-x320-matchElements pic x(321). *> String to hold matched elememts
       1 return-status      pic s9(9)  comp-5.

       linkage section.
       1 lnk-mail-id pic x any length.
       1 lnk-i9-status pic 9.

       procedure division using lnk-mail-id returning lnk-i9-status.
        *>call "CBL_DEBUGBREAK"
        
        move 0 to return-status
        move spaces to wss-x255-regex wss-x320-strToMatch wss-x320-matchElements
        
        move z"^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,63}$" to wss-x255-regex
        move function lower-case(lnk-mail-id) to wss-x320-strToMatch
        move fnztrim(wss-x320-strToMatch) to wss-x320-strToMatch
        move x'00' to wss-x320-matchElements
        call "regex" using wss-x255-regex wss-x320-strToMatch wss-x320-matchElements returning return-status
        inspect wss-x320-matchElements replacing all x"00" by space
        if wss-x320-matchElements = spaces then
         move 0 to lnk-i9-status
        else
         move 1 to lnk-i9-status
        end-if
        goback
        .
       end function fnemailcheckwithregex.
       *>**
