﻿      $set ilusing (System.ServiceModel)
      $set ilusing (System.ServiceModel.Activation)
      $set ilusing (System.ServiceModel.Web)
      $set ilusing (System.Runtime.Serialization) 
      
       class-id MyWebApp.CountryDetails public
       attribute DataContract
       attribute Serializable.     
               
       01 country string public attribute DataMember.
       01 population string public attribute DataMember. 
       01 kmarea string public attribute DataMember.
       01 kmdensity string public attribute DataMember.
       
       method-id new public.
       
       local-storage section.
       
       procedure division.
           
           goback.
       end method.
       
       end class.
      
      
       class-id MyWebApp.MyWebAppSvc    
       attribute ServiceContract(name Namespace = "")
       attribute AspNetCompatibilityRequirements (name RequirementsMode = type AspNetCompatibilityRequirementsMode::Allowed)
       .
       
       select optional country-file assign external dd_countryfile
       organization indexed
       access mode dynamic
       record key is country.
              
       fd country-file.
       01 country-rec.
       03 pos pic xxx.
       03 country pic x(30).
       03 population pic x(12).
       03 km-area pic x(12).
       03 km-density pic x(6).
       
       working-storage section.
             
       method-id GetMatches
       attribute OperationContract
       attribute WebGet(name ResponseFormat = type WebMessageFormat::Json)
       .
       
       local-storage section.
       procedure division using by value countryval as string returning res as string occurs any.
       
           set size of res to 0
           open input sharing with all other country-file 
           
            set res to self::DoGetMatches(countryval)
           close country-file
           goback.           
       end method.
       
       method-id GetCountryDetails
       attribute OperationContract
       attribute WebGet(name ResponseFormat = type WebMessageFormat::Json)
       .
       
       local-storage section.
       procedure division using by value countryval as string returning res as type CountryDetails.
       
           
           open input sharing with all other country-file 
           
            set res to self::DoGetCountryDetails(countryval)
           
           close country-file
           goback.           
       end method.
       
       method-id DoGetCountryDetails
       attribute OperationContract
       attribute WebGet(name ResponseFormat = type WebMessageFormat::Json)
       .
       
       local-storage section.
       procedure division using by value countryval as string returning res as type CountryDetails.
       
           move countryval to country
           start country-file key is equal country
             invalid key
               exit method
           end-start
       
           read country-file next record
           declare details as type CountryDetails
           set details to new CountryDetails
     
           set details::country to country
           set details::kmarea to km-area
           set details::kmdensity to km-density
           set details::population to population
           
           set res to details          
       
           goback.           
       end method.
       
       
       method-id DoGetMatches private.
       
       local-storage section.
       procedure division using by value countryval as string returning res as string occurs any.
       
           set size of res to 0
           
           move countryval to country
           start country-file key is greater than or equal country
             invalid key
               exit method
           end-start
       
           set size of res to 10
           declare i as binary-short = 0
           declare t as string
           
           perform until exit
             
             read country-file next
             at end
               exit perform
             not at end
          
             set t to country
             if not t::StartsWith(countryval) 
                exit perform
             end-if
             set res[i] to t::TrimEnd      
         
             add 1 to i
              if i = 10
                 exit perform
              end-if
             
             end-read
                                    
           end-perform
           
           goback.           
       end method.
              
       end class.