﻿      ********************************************************************************************************
      *
      * Copyright (C) Micro Focus 2010-2014.
      * All rights reserved.
      *
      *  This sample code is supplied for demonstration purposes only on an "as is" basis and "is for use at
      *  your own risk".
      *
      ********************************************************************************************************

       class-id WPFBook.WPFListView is partial
                 inherits type System.Windows.Window.

       working-storage section.
       01 myBook type BookWrapper.Book.

       method-id NEW.
       procedure division.
           invoke type System.Windows.Forms.Application::EnableVisualStyles()
           invoke self::InitializeComponent()
       end method.

       *>> <summary>
       *>> Starting with stock-no set to 1111 a perform loop calls the legacy program
       *>> with a read next, until the the end of the data file is reached.
       *>> Each call returns information on the stock item which is written to a
       *>> .NET list view items.
       *>> </summary>
       method-id PopulateBookList final private.
       local-storage section.
       01 stock-no              string.
       01 b-endoffile           condition-value value False.
       procedure division.

           move "1111" to stock-no

           try
               set myBook to type BookWrapper.Book::Read(stock-no)
           catch my-exception as type System.Exception
               set b-endoffile to true
           end-try

           perform with test before until b-endoffile

               *> add each book in the items collection of the listViewBooks.
               *> The Binding is described in the .xaml file.
               invoke self::listViewBooks::Items::Add(myBook)

               try
                   set myBook to type BookWrapper.Book::Next(myBook::StockNumber)
               catch my-exception as type System.Exception
                   set b-endoffile to true
               end-try

           end-perform
       end method.

       method-id Window_Loaded final private.
       procedure division using by value sender as object e as type System.Windows.RoutedEventArgs.
           invoke self::PopulateBookList()
       end method.

       method-id buttonCloseList_Click final private.
       procedure division using by value sender as object e as type System.Windows.RoutedEventArgs.
          invoke self::Close()
       end method.

       end class.
