﻿      ********************************************************************************************************
      *
      * Copyright (C) Micro Focus 2010-2014.
      * All rights reserved.
      *
      *  This sample code is supplied for demonstration purposes only on an "as is" basis and "is for use at
      *  your own risk".
      *
      ********************************************************************************************************

       class-id WPFBook.MainWindow is partial
                 inherits type System.Windows.Window.

       working-storage section.
       01 my-book type BookWrapper.Book.

       method-id NEW.
       procedure division.
           invoke type System.Windows.Forms.Application::EnableVisualStyles()
           invoke self::InitializeComponent()
       end method.

       method-id buttonRead_Click final private.
       procedure division using by value sender as object e as type System.Windows.RoutedEventArgs.
           try
               set my-book      to type BookWrapper.Book::Read(textBoxISBN::Text)
               invoke self::PopulateForm(my-book)
           catch my-exception as type System.Exception
               invoke self::DisplayException(my-exception)
           end-try
       end method.

       method-id buttonAdd_Click final private.
       local-storage section.
       01 my-Price             decimal.
       01 my-NumberOnHand      binary-long.
       01 my-NumberSold        binary-long.
       procedure division using by value sender as object e as type System.Windows.RoutedEventArgs.
           if textBoxOnhand::Text::Length = 0
               set textBoxOnhand::Text to "0"
           end-if

           try
               set my-NumberOnHand to type System.Convert::ToInt32(textBoxOnhand::Text)

               if textBoxSold::Text::Length = 0
                   set textBoxSold::Text to "0"
               end-if

               set my-NumberSold   to type System.Convert::ToInt32(textBoxSold::Text)

               if textBoxPrice::Text::Length = 0
                   set textBoxPrice::Text to "0"
               end-if

               set my-Price   to type System.Convert::ToDecimal(textBoxPrice::Text)

               set my-book to type BookWrapper.Book::Add(
                                          textBoxISBN::Text
                                          textBoxStockNo::Text
                                          textBoxTitle::Text
                                          textBoxAuthor::Text
                                          textBoxType::Text
                                          my-Price
                                          my-NumberOnHand
                                          my-NumberSold)

               invoke self::PopulateForm(my-book)
           catch my-formatException as type System.FormatException
               invoke self::DisplayException(my-formatException)
           catch my-exception as type System.Exception
               invoke self::DisplayException(my-exception)
           end-try
       end method.

       method-id buttonDelete_Click final private.
       procedure division using by value sender as object e as type System.Windows.RoutedEventArgs.
       try
               set my-book      to type BookWrapper.Book::Delete(textBoxISBN::Text)
               set my-book      to null
               invoke self::PopulateForm(my-book)
               set labelStatus::Content to "Deleted"
               set labelStatus::Foreground to type System.Windows.Media.Brushes::Blue
           catch my-exception as type System.Exception
               invoke self::DisplayException(my-exception)
           end-try
       end method.

       method-id buttonNext_Click final private.
       procedure division using by value sender as object e as type System.Windows.RoutedEventArgs.
       try
               set my-book       to type BookWrapper.Book::Next(textBoxISBN::Text)
               invoke self::PopulateForm(my-book)
           catch my-exception as type System.Exception
               invoke self::DisplayException(my-exception)
           end-try
       end method.

       method-id buttonQuit_Click final private.
       procedure division using by value sender as object e as type System.Windows.RoutedEventArgs.
           invoke self::Close()
       end method.

       method-id buttonList_Click final private.
       local-storage section.
       01 my-bookList           type WPFBook.WPFListView.
       procedure division using by value sender as object e as type System.Windows.RoutedEventArgs.
           set my-bookList to new WPFBook.WPFListView
           set my-bookList::Owner to self
           invoke my-bookList::ShowDialog()
       end method.

       method-id buttonTree_Click final private.
       local-storage section.
       01 my-bookTree          type WPFBook.BookTreeView.
       procedure division using by value sender as object e as type System.Windows.RoutedEventArgs.
            set my-bookTree to new WPFBook.BookTreeView
            set my-bookTree::Owner to self
            invoke my-bookTree::ShowDialog()
       end method.

       *>> <summary>
       *>> Moves the book data retrieved from the legacy program to the fields on
       *>> the winform.
       *>> </summary>
       *>> <param name="aBook"></param>
       method-id PopulateForm final private.
       local-storage section.
       procedure division using aBook as type BookWrapper.Book.

           if aBook <> null
               set self::labelStatus::Content to    ""
               set self::textBoxISBN::Text       to aBook::ISBN
               set self::textBoxStockNo::Text    to aBook::StockNumber
               set self::textBoxTitle::Text      to aBook::Title
               set self::textBoxAuthor::Text     to aBook::Author
               set self::textBoxType::Text       to aBook::Type
               set self::textBoxPrice::Text      to type System.Convert::ToString(aBook::RetailPrice)
               set self::textBoxOnhand::Text     to type System.Convert::ToString(aBook::NumberOnHand)
               set self::textBoxSold::Text       to type System.Convert::ToString(aBook::NumberSold)
               set self::textBoxStockValue::Text to type System.Convert::ToString(aBook::StockValue)
           else
               set  self::textBoxISBN::Text       to "***********"
               set  self::textBoxStockNo::Text    to "****"
               set  self::textBoxTitle::Text      to "*************************************"
               set  self::textBoxAuthor::Text     to "*************************************"
               set  self::textBoxType::Text       to "****"
               set  self::textBoxPrice::Text      to "****"
               set  self::textBoxOnhand::Text     to "****"
               set  self::textBoxSold::Text       to "****"
               set  self::textBoxStockValue::Text to "****"
           end-if

        end method.

       method-id DisplayException private.
       procedure division using by value lnkException as type System.Exception.

           set my-book to null
           invoke self::PopulateForm(my-book)
           set self::labelStatus::Content to lnkException::Message
       end method.

       end class.
