﻿      ********************************************************************************************************
      *
      * Copyright (C) Micro Focus 2010-2014.
      * All rights reserved.
      *
      *  This sample code is supplied for demonstration purposes only on an "as is" basis and "is for use at
      *  your own risk".
      *
      ********************************************************************************************************

       class-id WPFBook.BookTreeView is partial
                 inherits type System.Windows.Window.

       working-storage section.
       01 myBook type BookWrapper.Book.

       method-id NEW.
       procedure division.
           invoke type System.Windows.Forms.Application::EnableVisualStyles()
           invoke self::InitializeComponent()
       end method.

      *>> <summary>
      *>> Starting with stock-no set to 1111 a perform loop calls the legacy program
      *>> with a read next, until the the end of the data file is reached.
      *>> Each call returns information on the stock item which is written to a
      *>> .NET tree item.
      *>> Each tree item is in turn added to a .NET tree view.
      *>> </summary>
       method-id PopulateBookTree final private.
       local-storage section.
       01 treeNode1             type System.Windows.Controls.TreeViewItem.
       01 treeNode2             type System.Windows.Controls.TreeViewItem.
       01 stock-no              string.
       01 b-endoffile           condition-value value False.

       procedure division.

           move "1111" to stock-no

           try
               set myBook to type BookWrapper.Book::Read(stock-no)
           catch my-exception as type System.Exception
               set b-endoffile to true
           end-try

           perform with test before until b-endoffile

               set treeNode1 to new System.Windows.Controls.TreeViewItem
               set treeNode1::Header to myBook::Title
               invoke treeNode1::Items::Add(myBook::Author)
               invoke treeNode1::Items::Add(myBook::Type)
               invoke treeNode1::Items::Add(type System.Convert::ToString(myBook::RetailPrice))

               set treeNode2 to new System.Windows.Controls.TreeViewItem
               set treeNode2::Header to "Stock Details"
               invoke treeNode2::Items::Add(myBook::StockNumber)
               invoke treeNode2::Items::Add(type System.Convert::ToString(myBook::NumberOnHand))
               invoke treeNode2::Items::Add(type System.Convert::ToString(myBook::NumberSold))
      *> add the treeNode2 to the items of the treeNode1
               invoke treeNode1::Items::Add(treeNode2)
      *> add the treNode1 to the items of the treeView1
               invoke treeView1::Items::Add(treeNode1)

               try
                   set myBook to type BookWrapper.Book::Next(myBook::StockNumber)
               catch my-exception as type System.Exception
                   set b-endoffile to true
               end-try

           end-perform
       end method.

       method-id treeView1_Loaded final private.
       procedure division using by value sender as object e as type System.Windows.RoutedEventArgs.
           invoke self::PopulateBookTree()
       end method.

       method-id buttonTreeClose_Click final private.
       procedure division using by value sender as object e as type System.Windows.RoutedEventArgs.
           invoke self::Close()
       end method.

       end class.
