      ********************************************************************************************************
      *
      * Copyright (C) Micro Focus 2010-2014.
      * All rights reserved.
      *
      *  This sample code is supplied for demonstration purposes only on an "as is" basis and "is for use at
      *  your own risk".
      *
      ********************************************************************************************************

       *>> <summary>
       *>> Represents error codes for operations performed on books
       *>> </summary>
       enum-id BookWrapper.ExceptionCodes.
       working-storage section.
           78 DataFileNotFound.
           78 StockItemNotFound.
           78 NoMoreItemsLeft.
           78 ItemAlreadyExists.
           78 FileError.
       end enum.

       *>> <summary>
       *>> Specialized exception class for errors in the book wrapper.
       *>> </summary>
       class-id BookWrapper.BookException inherits type System.Exception.

       working-storage section.
       01 ExceptionCode type BookWrapper.ExceptionCodes.

       *>> <summary>
       *>> Constructor. Pass in the reason for the exception.
       *>> </summary>
       *>> <param name="eCode">The error code of the exception</param>
       method-id New public.
       procedure division using by value eCode as type BookWrapper.ExceptionCodes.
           set ExceptionCode to eCode
       end method.

       *>> <summary>
       *>> Returns the Exception code.
       *>> </summary>
       *>> <returns>The Exception code</returns>
       property-id Code type BookWrapper.ExceptionCodes.
       getter.
           set property-value to ExceptionCode
       end property.

       *>> <summary>
       *>> Return an exception message.
       *>> </summary>
       *>> <returns>The exception message</returns>
       property-id Message string override.
       getter.
           evaluate ExceptionCode
               when type BookWrapper.ExceptionCodes::DataFileNotFound
                   set property-value to "Error: Data file not found"
               when type BookWrapper.ExceptionCodes::StockItemNotFound
                   set property-value to "Error: Stock item not found"
               when type BookWrapper.ExceptionCodes::NoMoreItemsLeft
                   set property-value to "No more items left"
               when type BookWrapper.ExceptionCodes::ItemAlreadyExists
                   set property-value to "Error: Item already exists"
               when type BookWrapper.ExceptionCodes::FileError
                   set property-value to "File error"
           end-evaluate
       end property.
       end class.
