************************************************************************
*
*       Copyright (C) Micro Focus 1984-2015. All rights reserved.
*       All rights reserved.
*
************************************************************************
   
       Program-id. book.

       Environment division.
       input-output section.
       file-control.
           copy "FDbook.cpy".

       Data division.
       File section.
           FD bookfile is external.
           copy "RDbook.cpy" replacing ==(prefix)== by ==b==.

       working-storage section.
       01 notUsed          pic x.

       01 ws-file-status   pic xx.
       01 ls-call-status   pic x(2) comp-5.
       01 anyDate          pic x(10).

       linkage section.
       01 lnk-function     pic x.
           88 read-record    value "1".
           88 add-record     value "2".
           88 delete-record  value "3".
           88 next-record    value "4".
       01 lnk-file-status  pic xx.
       copy "RDbook.cpy" replacing ==(prefix)== by ==lnk-b==.


       procedure division using lnk-function
                                lnk-b-details
                                lnk-file-status.
       main section.
           accept anyDate from DATE
           .

           call "CBL_TOUPPER" using lnk-b-text-details
                           by value length lnk-b-text-details
                          returning ls-call-status

           evaluate true
            when read-record
               perform do-read-record

            when add-record
               perform do-add-record

            when delete-record
               perform do-delete-record

            when next-record
               perform do-next-record

           end-evaluate
           exit program
           stop run
           .

       do-read-record section.
           call "bookread" using lnk-b-details lnk-file-status
           .

       do-next-record section.
           open input bookfile
           if ws-file-status <> "00"
               initialize lnk-b-details
               move all '*' to lnk-b-text-details

               move ws-file-status to lnk-file-status
               exit section
           end-if

           move lnk-b-stockno to b-stockno
           start bookfile key > b-stockno
           read bookfile next

           move ws-file-status to lnk-file-status
           if ws-file-status = "00"
               move b-title to lnk-b-title
               move b-type to lnk-b-type
               move b-author to lnk-b-author
               move b-stockno to lnk-b-stockno
               move b-retail to lnk-b-retail
               move b-onhand to lnk-b-onhand
               move b-sold to lnk-b-sold
           else
               initialize lnk-b-details
               move all '*' to lnk-b-text-details
           end-if
           close bookfile
           .

       do-add-record section.
           call "bookwrite" using lnk-b-details lnk-file-status
           If lnk-file-status = "02"
               move "OK" to  lnk-file-status
           end-if
           .

       do-delete-record section.
           open i-o bookfile
           if ws-file-status <> "00"
               move ws-file-status to lnk-file-status
               exit section
           end-if

           evaluate true
            when lnk-b-stockno <> spaces
               move lnk-b-stockno to b-stockno
               read bookfile
               delete bookfile record

            when lnk-b-title <> spaces
               move lnk-b-title to b-title
               read bookfile key is b-title
               delete bookfile record

            when lnk-b-author <> spaces
               move lnk-b-author to b-author
               read bookfile key is b-author
               delete bookfile record

           when other
      *>------------No key specified - return unsuccessful read
               move "23" to ws-file-status

           end-evaluate

           move ws-file-status to lnk-file-status
           close bookfile
           .

