       IDENTIFICATION DIVISION.
       PROGRAM-ID.  QDEMO.
       ENVIRONMENT DIVISION.
       CONFIGURATION SECTION.
       DATA DIVISION.
       WORKING-STORAGE SECTION.

           COPY "rmpanels.ws".

      **************************************************
      *     Panel WORKING-STORAGE COPY files
      *
      *        These files are created by RMPANELS
      **************************************************
           COPY "custinfo.ws".
           COPY "message.ws".
              
       PROCEDURE DIVISION.

       MAIN-FUNCTION.
           MOVE "qdemo.lib" TO RMP--LIBRARY.
           SET RMP--DEBUG RMP--CLEAR TO TRUE.
           PERFORM RMP--DP-CUSTINFO.
           PERFORM DEMONSTRATE-FUNCTIONS.
           PERFORM RMP--RP-CUSTINFO.
           CALL RMP--RUNTIME USING RMP--U-DTF RMP--PARAMETERS.
           CALL RMP--RUNTIME USING RMP--U-HMC RMP--PARAMETERS.
           GOBACK.

       DEMONSTRATE-FUNCTIONS.
           PERFORM AF-DEMO.
           PERFORM CPP-DEMO.
           PERFORM CMO-DEMO.
           PERFORM CAF-DEMO.
           PERFORM IF-DEMO.
           PERFORM IAF-DEMO.
           PERFORM DA-DEMO.
           PERFORM DFI-DEMO.
           PERFORM DMO-DEMO.
           PERFORM PUM-DEMO.
           PERFORM SFA-DEMO.
           PERFORM SSR-DEMO.
           PERFORM SFE-DEMO.
           PERFORM SFH-DEMO.
           PERFORM SPE-DEMO.
           PERFORM SPH-DEMO.
           PERFORM UMO-DEMO.
           PERFORM VAF-DEMO.
           PERFORM VF-DEMO.

       AF-DEMO.
           MOVE "Accept Field Demonstration" TO MSG-TEXT.
           PERFORM SHOW-MSG.
           IF PB-OK
               MOVE "Enter value and press RETURN to continue"
                   TO CUSTINFO-COMMENTS (1)
               PERFORM SHOW-COMMENTS
               MOVE "CUSTINFO-NAME" TO RMP--FIELD-NAME
               PERFORM RMP--AF-CUSTINFO
               PERFORM REMOVE-COMMENTS.

       CPP-DEMO.
           MOVE "Change Panel Palette Demonstration" TO MSG-TEXT.
           PERFORM SHOW-MSG.
           IF PB-OK
               MOVE "RETURN or button to continue"
                   TO CUSTINFO-COMMENTS (1)
               MOVE 1 TO RMP--PALETTE
               PERFORM RMP--CPP-CUSTINFO
               MOVE "CUSTINFO-NAME" TO RMP--FIELD-NAME
               PERFORM RMP--AF-CUSTINFO
               MOVE 2 TO RMP--PALETTE
               PERFORM RMP--CPP-CUSTINFO
               PERFORM REMOVE-COMMENTS.

       CMO-DEMO.
           MOVE "Check Menu Option Demonstration" TO MSG-TEXT.
           PERFORM SHOW-MSG.
           IF PB-OK
               MOVE
                 "Select pulldown menu option and it will"
                   TO CUSTINFO-COMMENTS (1)
               MOVE
                 "be checked" TO CUSTINFO-COMMENTS (2)
               MOVE
                 "RETURN or button to continue" TO CUSTINFO-COMMENTS (4)
               PERFORM SHOW-COMMENTS
               SET RMP--FIRST-FIELD TO TRUE
               PERFORM WITH TEST AFTER UNTIL PB-CONTINUE
                   PERFORM RMP--EE-CUSTINFO
                   IF RMP--MENU-COMMAND
                       PERFORM RMP--CMO-CUSTINFO
                   END-IF
               END-PERFORM
               PERFORM REMOVE-COMMENTS.

       CAF-DEMO.
           MOVE "Clear All Fields Demonstration" TO MSG-TEXT.
           PERFORM SHOW-MSG.
           IF PB-OK
               PERFORM RMP--CAF-CUSTINFO
               PERFORM RMP--DAF-CUSTINFO.

       IF-DEMO.
           MOVE "Initialize Field Demonstration" TO MSG-TEXT.
           PERFORM SHOW-MSG.
           IF PB-OK
               MOVE "CUSTINFO-CITY" TO RMP--FIELD-NAME
               PERFORM RMP--IF-CUSTINFO
               PERFORM RMP--DF-CUSTINFO.

       DA-DEMO.
           MOVE "Enable/Disable All Demonstration" TO MSG-TEXT.
           PERFORM SHOW-MSG.
           IF PB-OK
               MOVE "RETURN or button to continue"
                   TO CUSTINFO-COMMENTS (1)
               PERFORM RMP--DA-CUSTINFO
               MOVE "PB-CONTINUE" TO RMP--FIELD-NAME
               PERFORM RMP--EFI-CUSTINFO
               PERFORM RMP--DAF-CUSTINFO
               MOVE "PB-CONTINUE" TO RMP--NEXT-FIELD
               PERFORM RMP--EE-CUSTINFO WITH TEST AFTER
                 UNTIL PB-CONTINUE
               PERFORM RMP--EA-CUSTINFO
               PERFORM RMP--DAF-CUSTINFO
               PERFORM REMOVE-COMMENTS.

       DFI-DEMO.
           MOVE "Disable Field Demonstration" TO MSG-TEXT.
           PERFORM SHOW-MSG.
           IF PB-OK
               MOVE "ID and name fields disabled"
                   TO CUSTINFO-COMMENTS (1)
               MOVE "RETURN or button to continue"
                   TO CUSTINFO-COMMENTS (3)
               PERFORM SHOW-COMMENTS
               MOVE "CUSTINFO-ID" TO RMP--FIELD-NAME
               PERFORM RMP--DFI-CUSTINFO
               PERFORM RMP--DF-CUSTINFO
               MOVE "CUSTINFO-NAME" TO RMP--FIELD-NAME
               PERFORM RMP--DFI-CUSTINFO
               PERFORM RMP--DF-CUSTINFO
               SET RMP--FIRST-FIELD TO TRUE
               PERFORM RMP--EE-CUSTINFO WITH TEST AFTER
                 UNTIL PB-CONTINUE
               PERFORM RMP--EA-CUSTINFO
               PERFORM REMOVE-COMMENTS.

       DMO-DEMO.
           MOVE "Disable Menu Option Demonstration" TO MSG-TEXT.
           PERFORM SHOW-MSG.
           IF PB-OK
               MOVE "File menu options disabled"
                   TO CUSTINFO-COMMENTS (1)
               MOVE "RETURN or button to continue"
                   TO CUSTINFO-COMMENTS (3)
               PERFORM SHOW-COMMENTS
               MOVE "OPTION1" TO RMP--COMMAND-NAME
               PERFORM RMP--DMO-CUSTINFO
               MOVE "OPTION2" TO RMP--COMMAND-NAME
               PERFORM RMP--DMO-CUSTINFO
               SET RMP--FIRST-FIELD TO TRUE
               PERFORM RMP--EE-CUSTINFO WITH TEST AFTER
                 UNTIL PB-CONTINUE
               MOVE "OPTION1" TO RMP--COMMAND-NAME
               PERFORM RMP--EMO-CUSTINFO
               MOVE "OPTION2" TO RMP--COMMAND-NAME
               PERFORM RMP--EMO-CUSTINFO
               PERFORM REMOVE-COMMENTS.

       IAF-DEMO.
           MOVE "Initialize All Fields Demonstration" TO MSG-TEXT.
           PERFORM SHOW-MSG.
           IF PB-OK
               PERFORM RMP--IAF-CUSTINFO
               PERFORM RMP--DAF-CUSTINFO.

       PUM-DEMO.
           MOVE "Popup Menu Demonstration" TO MSG-TEXT.
           PERFORM SHOW-MSG.
           IF PB-OK
               MOVE 15 TO RMP--PANEL-LINE RMP--PANEL-POS
               MOVE "OPTION2" TO RMP--COMMAND-NAME
               PERFORM RMP--PUM-CUSTINFO.

       SFA-DEMO.
           MOVE "Set Field Attribute Demonstration" TO MSG-TEXT.
           PERFORM SHOW-MSG.
           IF PB-OK
               MOVE "RETURN or button to continue"
                   TO CUSTINFO-COMMENTS (1)
               PERFORM SHOW-COMMENTS
               MOVE "CUSTINFO-NAME" TO RMP--FIELD-NAME
               MOVE "F" TO RMP--ATTRIBUTE
               PERFORM RMP--SFA-CUSTINFO
               PERFORM RMP--DF-CUSTINFO
               MOVE "CUSTINFO-ADDR-1" TO RMP--FIELD-NAME
               MOVE "F" TO RMP--ATTRIBUTE
               PERFORM RMP--SFA-CUSTINFO
               PERFORM RMP--DF-CUSTINFO
               MOVE "CUSTINFO-ADDR-2" TO RMP--FIELD-NAME
               MOVE "F" TO RMP--ATTRIBUTE
               PERFORM RMP--SFA-CUSTINFO
               PERFORM RMP--DF-CUSTINFO
               SET RMP--FIRST-FIELD TO TRUE
               PERFORM RMP--EE-CUSTINFO WITH TEST AFTER
                 UNTIL PB-CONTINUE
               MOVE SPACE TO RMP--ATTRIBUTE
               MOVE "CUSTINFO-NAME" TO RMP--FIELD-NAME
               PERFORM RMP--SFA-CUSTINFO
               PERFORM RMP--DF-CUSTINFO
               MOVE "CUSTINFO-ADDR-1" TO RMP--FIELD-NAME
               PERFORM RMP--SFA-CUSTINFO
               PERFORM RMP--DF-CUSTINFO
               MOVE "CUSTINFO-ADDR-2" TO RMP--FIELD-NAME
               PERFORM RMP--SFA-CUSTINFO
               PERFORM RMP--DF-CUSTINFO
               PERFORM REMOVE-COMMENTS.
       SSR-DEMO.
           MOVE "Set Scroll Bar Range Demonstration" TO MSG-TEXT.
           PERFORM SHOW-MSG.
           IF PB-OK
               MOVE 100 TO RMP--SB-MIN
               MOVE 500 TO RMP--SB-MAX
               MOVE 10 TO RMP--SB-STEP
               MOVE 50 TO RMP--SB-PAGE
               PERFORM RMP--SSR-CUSTINFO.

       SFE-DEMO.
           MOVE "Show Field Error Demonstration" TO MSG-TEXT.
           PERFORM SHOW-MSG.
           IF PB-OK
               MOVE "CUSTINFO-ID" TO RMP--FIELD-NAME
               PERFORM RMP--SFE-CUSTINFO.

       SFH-DEMO.
           MOVE "Show Field Help Demonstration" TO MSG-TEXT.
           PERFORM SHOW-MSG.
           IF PB-OK
               MOVE "CUSTINFO-ID" TO RMP--FIELD-NAME
               PERFORM RMP--SFH-CUSTINFO.

       SPE-DEMO.
           MOVE "Show Panel Error Demonstration" TO MSG-TEXT.
           PERFORM SHOW-MSG.
           IF PB-OK
               PERFORM RMP--SPE-CUSTINFO.

       SPH-DEMO.
           MOVE "Show Panel Help Demonstration" TO MSG-TEXT.
           PERFORM SHOW-MSG.
           IF PB-OK
               PERFORM RMP--SPH-CUSTINFO.

       UMO-DEMO.
           MOVE "Uncheck Menu Option Demonstration" TO MSG-TEXT.
           PERFORM SHOW-MSG.
           IF PB-OK
               MOVE
                 "Select pulldown menu option and it will"
                   TO CUSTINFO-COMMENTS (1)
               MOVE
                 "be unchecked" TO CUSTINFO-COMMENTS (2)
               MOVE
                 "RETURN or button to continue" TO CUSTINFO-COMMENTS (4)
               PERFORM SHOW-COMMENTS
               SET RMP--FIRST-FIELD TO TRUE
               PERFORM WITH TEST AFTER UNTIL PB-CONTINUE
                   PERFORM RMP--EE-CUSTINFO
                   IF RMP--MENU-COMMAND
                       PERFORM RMP--UMO-CUSTINFO
                   END-IF
               END-PERFORM
               PERFORM REMOVE-COMMENTS.

       VAF-DEMO.
           MOVE "Validate all Fields Demonstration" TO MSG-TEXT.
           PERFORM SHOW-MSG.
           IF PB-OK
               MOVE "1234" TO CUSTINFO-ID
               MOVE "CUSTINFO-ID" TO RMP--FIELD-NAME
               PERFORM RMP--DF-CUSTINFO
               MOVE SPACE TO CUSTINFO-NAME
               MOVE "CUSTINFO-NAME" TO RMP--FIELD-NAME
               PERFORM RMP--DF-CUSTINFO
               PERFORM RMP--VAF-CUSTINFO
               IF RMP--INVALID-INPUT
                   PERFORM RMP--SFE-CUSTINFO.

       VF-DEMO.
           MOVE "Validate Field Demonstration" TO MSG-TEXT.
           PERFORM SHOW-MSG.
           IF PB-OK
               MOVE CUSTINFO-NAME TO RMP--FIELD-NAME
               PERFORM RMP--VAF-CUSTINFO
               IF RMP--INVALID-INPUT
                   PERFORM RMP--SFE-CUSTINFO.

       SHOW-MSG.
           SET RMP--SHOW-FIELDS TO TRUE.
           MOVE 999 TO RMP--PANEL-LINE RMP--PANEL-POS.
           PERFORM RMP--DP-MESSAGE.
           SET RMP--FIRST-FIELD TO TRUE.
           PERFORM RMP--EE-MESSAGE
               WITH TEST AFTER UNTIL RMP--BUTTON-PRESS.
           PERFORM RMP--RP-MESSAGE.

       SHOW-COMMENTS.
           MOVE "CUSTINFO-COMMENTS" TO RMP--FIELD-NAME.
           MOVE 0 TO RMP--FIELD-OCCUR.
           PERFORM RMP--DF-CUSTINFO.

       REMOVE-COMMENTS.
           MOVE SPACE TO CUSTINFO-COMMENTS (1).
           MOVE SPACE TO CUSTINFO-COMMENTS (2).
           MOVE SPACE TO CUSTINFO-COMMENTS (3).
           MOVE SPACE TO CUSTINFO-COMMENTS (4).
           PERFORM SHOW-COMMENTS.


      **************************************************
      *     PANEL PROCEDURE COPY FILES
      *
      *        THESE FILES ARE CREATED BY RMPANELS
      *
      **************************************************
          COPY "custinfo.prc".
          COPY "message.prc".              
