/****************************************************************************
 *
 *   Copyright (C) Micro Focus IP Development Limited  1984-2011. 
 *   All rights reserved.
 *
 *   The software and information contained herein are proprietary to, and
 *   comprise valuable trade secrets of, Micro Focus IP Development Limited, 
 *   which intends to preserve as trade secrets such software and 
 *   information. This software is an unpublished copyright of Micro Focus  
 *   and may not be used, copied, transmitted, or stored in any manner.  
 *   This software and information or any other copies thereof may not be
 *   provided or otherwise made available to any other person.
 *   
 *   $Id: mf.eclipse.codetemplates.xml 357473 2010-01-07 17:15:13Z niy $
 ****************************************************************************/

package com.microfocus.book.rest;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="link")
public class Link
{
	public static final String FIRST 	= "first";
	public static final String LAST 	= "last";
	public static final String NEXT 	= "next";
	public static final String PREV 	= "previous";
	public static final String SELF 	= "self";
	
	private String rel;
	private String href;
	
	public Link()
	{
		this("","");
	}

	public Link(String rel, String href)
	{
		this.rel = rel;
		this.href = href;
	}
	
	@XmlElement(name = "rel")
	public String getRel()
	{
		return rel;
	}

	public void setRel(String rel)
	{
		this.rel = rel;
	}

	@XmlElement(name = "href")
	public String getHref()
	{
		return href;
	}

	public void setHref(String href)
	{
		this.href = href;
	}
	
	public static Link first(String href)
	{
		return new Link(FIRST, href);
	}
	
	public static Link last(String href)
	{
		return new Link(LAST, href);
	}
	
	public static Link next(String href)
	{
		return new Link(NEXT, href);
	}
	
	public static Link prev(String href)
	{
		return new Link(PREV, href);
	}
	
	public static Link self(String href)
	{
		return new Link(SELF, href);
	}
}
