/****************************************************************************
 *
 *   Copyright (C) Micro Focus IP Development Limited  1984-2011. 
 *   All rights reserved.
 *
 *   The software and information contained herein are proprietary to, and
 *   comprise valuable trade secrets of, Micro Focus IP Development Limited, 
 *   which intends to preserve as trade secrets such software and 
 *   information. This software is an unpublished copyright of Micro Focus  
 *   and may not be used, copied, transmitted, or stored in any manner.  
 *   This software and information or any other copies thereof may not be
 *   provided or otherwise made available to any other person.
 *   
 *   $Id: mf.eclipse.codetemplates.xml 357473 2010-01-07 17:15:13Z niy $
 ****************************************************************************/

package com.microfocus.book.rest;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="book")
public class JsonBookIdGetResponse
{
	private JaxbBookBean data;
	private List<Link> links;
	
	public JsonBookIdGetResponse()
	{
		data = new JaxbBookBean();
		links = new ArrayList<Link>();
	}
	
	public JsonBookIdGetResponse(JaxbBookBean data, List<Link> links)
	{
		this.data = data;
		this.links = links;
	}
	
	@XmlElement(name = "bookdata")
	public JaxbBookBean getData()
	{
		return data;
	}

	public void setData(JaxbBookBean data)
	{
		this.data = data;
	}

	@XmlElement(name = "links")
	public List<Link> getLinks()
	{
		return links;
	}

	public void setLinks(List<Link> links)
	{
		this.links = links;
	}
}
