package com.microfocus.book.rest;

import com.microfocus.book.BookLegacy;
import com.microfocus.book.Details;
import com.microfocus.book.FileStatus;
import com.microfocus.book.Filename;
import com.microfocus.cobol.program.IObjectControl;
import com.microfocus.cobol.program.ScaledInteger;
import com.microfocus.cobol.runtimeservices.IRunUnit;
import com.microfocus.cobol.runtimeservices.RunUnit;

public class JaxbBookInterface
{
	private static final String READ_RECORD = "1";
	private static final String ADD_RECORD = "2";
	private static final String DELETE_RECORD = "3";
	private static final String NEXT_RECORD = "4";
	private static final String PREV_RECORD = "5";
	private static final String FIRST_RECORD = "6";
	private static final String LAST_RECORD = "7";
	private static final String UPDATE_RECORD = "8";

	private static final String BOOK_FILE = "C:/work/garethm/JavaWebServicesDemos/COBOLJSPDemo/CobolBook/bookfile.dat";

	public JaxbBookBean readBook(BookId stockNo) throws JavaBookException
	{
		return doBookOperation(READ_RECORD, stockNo);
	}

	public JaxbBookBean addBook(JaxbBookBean book) throws JavaBookException
	{
		doBookOperation(ADD_RECORD, book);

		return book;
	}

	public JaxbBookBean updateBook(JaxbBookBean book) throws JavaBookException
	{
		doBookOperation(UPDATE_RECORD, book);

		return book;
	}

	public JaxbBookBean deleteBook(BookId stockNo) throws JavaBookException
	{
		return doBookOperation(DELETE_RECORD, stockNo);
	}

	public JaxbBookBean nextBook(BookId stockNo) throws JavaBookException
	{
		return doBookOperation(NEXT_RECORD, stockNo);
	}
	
	public BookId nextId(BookId stockNo) throws JavaBookException
	{
		if(lastId().equals(stockNo))
		{
			return stockNo;
		}
		else
		{
			return new BookId(nextBook(stockNo).getStockno());
		}
	}

	public JaxbBookBean prevBook(BookId stockNo) throws JavaBookException
	{
		return doBookOperation(PREV_RECORD, stockNo);
	}
	
	public BookId prevId(BookId stockNo) throws JavaBookException
	{
		if(firstId().equals(stockNo))
		{
			return stockNo;
		}
		else
		{
			return new BookId(prevBook(stockNo).getStockno());
		}
	}

	private static final BookId FIRST_BOOK_ID = new BookId("1111");
	public JaxbBookBean firstBook() throws JavaBookException
	{
		return doBookOperation(FIRST_RECORD, FIRST_BOOK_ID);
	}
	
	public BookId firstId() throws JavaBookException
	{
		return new BookId(firstBook().getStockno());
	}


	private static final BookId LAST_BOOK_ID = new BookId("9999");
	public JaxbBookBean lastBook() throws JavaBookException
	{
		return doBookOperation(LAST_RECORD, LAST_BOOK_ID);
	}
	
	public BookId lastId() throws JavaBookException
	{
		return new BookId(lastBook().getStockno());
	}

	private JaxbBookBean doBookOperation(String function, BookId stockId) throws JavaBookException
	{
		IRunUnit runUnit = new RunUnit();
		BookLegacy bookLegacy = new BookLegacy();
		JaxbBookBean output = new JaxbBookBean();
		runUnit.Add(bookLegacy);
		Filename filename = getFilenameObject(runUnit, BOOK_FILE);

		bookLegacy.SET_FILENAME(filename);

		Details details = getObject(runUnit, Details.class);
		FileStatus status = getObject(runUnit, FileStatus.class);
		details.setStockno(stockId.id);

		bookLegacy.BookLegacy(function, details, status);

		throwExceptionIfError(status);

		jaxbBookBeanFromDetails(details, output);

		runUnit.StopRun();
		
		return output;
	}

	private void doBookOperation(String function, JaxbBookBean book) throws JavaBookException
	{
		IRunUnit runUnit = new RunUnit();
		BookLegacy bookLegacy = new BookLegacy();
		runUnit.Add(bookLegacy);
		Filename filename = getFilenameObject(runUnit, BOOK_FILE);

		bookLegacy.SET_FILENAME(filename);

		Details details = getObject(runUnit, Details.class);
		FileStatus status = getObject(runUnit, FileStatus.class);
		jaxbBookBeanToDetails(details, book);

		bookLegacy.BookLegacy(function, details, status);

		throwExceptionIfError(status);

		jaxbBookBeanFromDetails(details, book);

		runUnit.StopRun();
	}
	
	private static void jaxbBookBeanFromDetails(Details details, JaxbBookBean book)
	{
		book.setStockno(details.getStockno().trim());
		book.setIsbn("" + details.getIsbn());
		book.setTitle(details.getTitle().trim());
		book.setAuthor(details.getAuthor().trim());
		book.setType(details.getType().trim());
		book.setPrice(details.getRetail().toString());
		book.setOnhand("" + details.getOnhand());
		book.setSold("" + details.getSold());
		ScaledInteger stockvalInt = details.getRetail().multiply(new ScaledInteger(details.getOnhand(), 0));
		book.setStockval(stockvalInt.toString());
	}

	private static void jaxbBookBeanToDetails(Details details, JaxbBookBean book)
	{
		details.setStockno(book.getStockno());
		details.setIsbn(Long.parseLong(book.getIsbn()));
		details.setTitle(book.getTitle());
		details.setAuthor(book.getAuthor());
		details.setType(book.getType());
		details.setRetail(ScaledInteger.parseScaledInteger(book.getPrice()));

		int onHandInt = Integer.parseInt(book.getOnhand());
		if(onHandInt < 0)
			throw new RuntimeException("The number of books on hand must be 0 or positive");
		details.setOnhand(onHandInt);

		int soldInt = Integer.parseInt(book.getSold());
		if(soldInt < 0)
			throw new RuntimeException("The number of books sold must be 0 or positive");
		details.setSold(soldInt);
	}

	private static void throwExceptionIfError(FileStatus statusCode) throws JavaBookException
	{
		throwExceptionIfError(statusCode.getFileStatus().trim());
	}

	private static void throwExceptionIfError(String statusCode) throws JavaBookException
	{
		if(!"00".equals(statusCode) && !"02".equals(statusCode))
		{
			throw new JavaBookException(statusCode);
		}
	}

	private static Filename getFilenameObject(IRunUnit runUnit, String filename)
	{
		Filename output = getObject(runUnit, Filename.class);

		output.setFilename(filename);

		return output;
	}

	private static <T extends IObjectControl> T getObject(IRunUnit runUnit, Class<T> cls)
	{
		try
		{
			T output = cls.newInstance();
			runUnit.Add(output);

			return output;
		}
		catch(Throwable t)
		{
			throw new RuntimeException(t);
		}
	}
}
