package com.microfocus.book.rest;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name = "book")
public class JaxbBookBean
{
	private String stockno;
	private String isbn;
	private String title;
	private String author;
	private String type;
	private String price;
	private String onhand;
	private String sold;
	private String stockval;

	JaxbBookBean()
	{
		this("0000", "0", "", "", "", "0.0", "0", "0", "0.0");
	}

	JaxbBookBean(String stockno, String isbn, String title, String author, String type, String price, String onhand, String sold, String stockval)
	{
		this.stockno = stockno;
		this.isbn = isbn;
		this.title = title;
		this.author = author;
		this.type = type;
		this.price = price;
		this.onhand = onhand;
		this.sold = sold;
		this.stockval = stockval;
	}

	@XmlElement(name = "stockno")
	public String getStockno()
	{
		return stockno;
	}

	public void setStockno(String stockno)
	{
		this.stockno = stockno;
	}

	@XmlElement(name = "isbn")
	public String getIsbn()
	{
		return isbn;
	}

	public void setIsbn(String isbn)
	{
		this.isbn = isbn;
	}

	@XmlElement(name = "title")
	public String getTitle()
	{
		return title;
	}

	public void setTitle(String title)
	{
		this.title = title;
	}

	@XmlElement(name = "author")
	public String getAuthor()
	{
		return author;
	}

	public void setAuthor(String author)
	{
		this.author = author;
	}

	@XmlElement(name = "type")
	public String getType()
	{
		return type;
	}

	public void setType(String type)
	{
		this.type = type;
	}

	@XmlElement(name = "price")
	public String getPrice()
	{
		return price;
	}

	public void setPrice(String price)
	{
		this.price = price;
	}

	@XmlElement(name = "onhand")
	public String getOnhand()
	{
		return onhand;
	}

	public void setOnhand(String onhand)
	{
		this.onhand = onhand;
	}

	@XmlElement(name = "sold")
	public String getSold()
	{
		return sold;
	}

	public void setSold(String sold)
	{
		this.sold = sold;
	}

	@XmlElement(name = "stockval")
	public String getStockval()
	{
		return stockval;
	}

	public void setStockval(String stockval)
	{
		this.stockval = stockval;
	}

	public static JaxbBookBean blankBook()
	{
		return msgBook("*************************************");
	}

	public static JaxbBookBean msgBook(String msg)
	{
		String stockno = "****";
		String isbn = "*************";
		String title = msg;
		String author = "*************************************";
		String type = "****";
		String price = "****";
		String onhand = "****";
		String sold = "****";
		String stockval = "****";

		return new JaxbBookBean(stockno, isbn, title, author, type, price, onhand, sold, stockval);
	}
}