package com.microfocus.book.rest;

import java.util.*;

public class JavaBookException extends Exception
{

  /**
	 * 
	 */
  private static final long serialVersionUID = -3882735817601888938L;

  private static final Map<String, String> messages;
  private static final String unknownErrorMessage = "Unknown Error: ";

  public final String statusCode;

  public JavaBookException(String statusCode)
  {
    super(messages.containsKey(statusCode) ? messages.get(statusCode)
        : unknownErrorMessage + statusCode);
    this.statusCode = statusCode;
  }

  static
  {
    messages = new HashMap<String, String>();
    messages.put("35", "Error: Data file not found");
    messages.put("23", "Error: Stock item not found");
    messages.put("46", "No more items left");
    messages.put("99", "Error: Item already exists");
    messages.put("01", "Error: File error");
    messages.put("B1", "Error: No key entered");
  }
}