/****************************************************************************
 *
 *   Copyright (C) Micro Focus IP Development Limited  1984-2011. 
 *   All rights reserved.
 *
 *   The software and information contained herein are proprietary to, and
 *   comprise valuable trade secrets of, Micro Focus IP Development Limited, 
 *   which intends to preserve as trade secrets such software and 
 *   information. This software is an unpublished copyright of Micro Focus  
 *   and may not be used, copied, transmitted, or stored in any manner.  
 *   This software and information or any other copies thereof may not be
 *   provided or otherwise made available to any other person.
 *   
 *   $Id: mf.eclipse.codetemplates.xml 357473 2010-01-07 17:15:13Z niy $
 ****************************************************************************/

package com.microfocus.book.rest;

import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBContext;

import com.sun.jersey.api.json.JSONConfiguration;
import com.sun.jersey.api.json.JSONJAXBContext;

@Provider
public class JAXBContextResolver implements ContextResolver<JAXBContext>
{
	private JAXBContext context;
	private Class<?>[] types = {JsonBookGetResponse.class};

	public JAXBContextResolver() throws Exception
	{
		this.context = new JSONJAXBContext(JSONConfiguration.mapped().arrays("data").build(), types);
	}

	public JAXBContext getContext(Class<?> objectType)
	{
		return (types[0].equals(objectType)) ? context : null;
	}
}
