/****************************************************************************
 *
 *   Copyright (C) Micro Focus IP Development Limited  1984-2011. 
 *   All rights reserved.
 *
 *   The software and information contained herein are proprietary to, and
 *   comprise valuable trade secrets of, Micro Focus IP Development Limited, 
 *   which intends to preserve as trade secrets such software and 
 *   information. This software is an unpublished copyright of Micro Focus  
 *   and may not be used, copied, transmitted, or stored in any manner.  
 *   This software and information or any other copies thereof may not be
 *   provided or otherwise made available to any other person.
 *   
 *   $Id: mf.eclipse.codetemplates.xml 357473 2010-01-07 17:15:13Z niy $
 ****************************************************************************/

package com.microfocus.book.rest;

import java.util.ArrayList;
import java.util.List;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

import com.sun.jersey.api.client.ClientResponse.Status;

@Path(BookUrl.book + BookUrl.jsonExt)
public class BookUrl
{
	public static final String idName = "id";
	public static final String limitName = "limit";
	public static final String book = "book";
	public static final String extName = "ext";
	public static final String jsonExt ="{" + extName + ":(\\.json)?}";
	public static final int MAX_LIMIT = 25;
	public static final int DEFAULT_LIMIT = 5;
	
	@Context
	UriInfo uri;

	@GET
	@Produces(MediaType.APPLICATION_JSON)
	public Response jsonGetBooks(@PathParam(extName) String ext, @QueryParam(idName) BookId id, @QueryParam(limitName) String limitStr)
	{
		JsonBookGetResponse output;
		int limit = DEFAULT_LIMIT;
		
		try
		{
			if(limitStr != null)
			{
				limit = Integer.parseInt(limitStr);
				
				if(limit < 0)
				{
					limit = DEFAULT_LIMIT;
				}
				
				if(limit > MAX_LIMIT)
				{
					limit = MAX_LIMIT;
				}
			}
		}
		catch(NumberFormatException nfe)
		{
			return Response.status(Status.NOT_FOUND).build();
		}
		
		try
		{
			if(id == null)
			{
				JaxbBookInterface instance = new JaxbBookInterface();
				id = instance.firstId();
			}
			output = getBooks(id, ext, limit);
		}
		catch(JavaBookException e)
		{
			return Response.status(Status.NOT_FOUND).build();
		}

		return Response.ok(output).build();
	}
	
	private JsonBookGetResponse getBooks(BookId id, String ext, int limit) throws JavaBookException
	{
		List<JsonBookIdGetResponse> data = new ArrayList<JsonBookIdGetResponse>();
		JaxbBookInterface instance = new JaxbBookInterface();

		BookId firstId = id;
		try
		{
			instance.readBook(id);
		}
		catch(JavaBookException jbe)
		{
			if(jbe.statusCode.equals("23"))
			{
				firstId = instance.nextId(id);
			}
		}
		
		BookId currentId = firstId;
		for(int i = 0; i < limit; i++)
		{
			JsonBookIdGetResponse book = getBook(currentId, ext);
			data.add(book);
			
			BookId nextId = instance.nextId(currentId);
			
			if(nextId.equals(currentId))
			{
				break;
			}
			else
			{
				currentId = nextId;
			}
		}
		
		BookId nextId = currentId;
		BookId prevId = firstId;
		
		for(int i = 0; i < limit; i++)
		{
			prevId = instance.prevId(prevId);
		}
		
		List<Link> links = new ArrayList<Link>();
		String baseUri = uri.getBaseUri() + BookUrl.book + ext;
		links.add(Link.first(baseUri + queryString(instance.firstId(), limit)));
		links.add(Link.last(baseUri + queryString(instance.lastId(), limit)));
		links.add(Link.self(baseUri + queryString(id, limit)));
		links.add(Link.prev(baseUri + queryString(prevId, limit)));
		links.add(Link.next(baseUri + queryString(nextId, limit)));

		return new JsonBookGetResponse(data, links);
	}
	
	private JsonBookIdGetResponse getBook(BookId id, String ext) throws JavaBookException
	{
		JaxbBookInterface instance = new JaxbBookInterface();
		JaxbBookBean book = instance.readBook(id);;
		List<Link> links = new ArrayList<Link>();
		String baseUri = uri.getBaseUri() + BookUrl.book + "/";
		links.add(Link.self(baseUri + id + ext));

		return new JsonBookIdGetResponse(book, links);
	}
	
	private String queryString(BookId id, int limit)
	{
		return "?" + idName + "=" + id + "&" + limitName + "=" + limit;
	}
}
