package com.microfocus.book.rest;

import java.util.ArrayList;
import java.util.List;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBElement;

import com.sun.jersey.api.client.ClientResponse.Status;

@Path(BookUrl.book + "/" + BookIdUrl.id + BookUrl.jsonExt)
public class BookIdUrl
{
	@Context
	UriInfo uri;
	
	
	public static final String id = "{" + BookUrl.idName + ":"+ BookId.idRegExStr + "}";

	@GET
	@Produces(MediaType.APPLICATION_JSON)
	public Response jsonGetBook(@PathParam(BookUrl.idName) BookId id, @PathParam(BookUrl.extName) String ext)
	{
		JaxbBookInterface instance = new JaxbBookInterface();

		JaxbBookBean book;
		List<Link> links = new ArrayList<Link>();
		try
		{
			book = instance.readBook(id);
			String baseUri = uri.getBaseUri() + BookUrl.book + "/";
			links.add(Link.first(baseUri + instance.firstId() + ext));
			links.add(Link.last(baseUri + instance.lastId() + ext));
			links.add(Link.self(baseUri + id + ext));
			links.add(Link.prev(baseUri + instance.prevId(id) + ext));
			links.add(Link.next(baseUri + instance.nextId(id) + ext));
		}
		catch(JavaBookException e)
		{
			return Response.status(Status.NOT_FOUND).build();
		}
		
		JsonBookIdGetResponse output = new JsonBookIdGetResponse(book, links);

		return Response.ok(output).build();
	}
	
	@PUT
	@Consumes(MediaType.APPLICATION_JSON)
	public Response jsonPutBook(JAXBElement<JaxbBookBean> parseBook, @PathParam(BookUrl.idName) BookId id)
	{
		JaxbBookBean book = parseBook.getValue();
		book.setStockno(id.id);
		JaxbBookInterface instance = new JaxbBookInterface();

		try
		{
			instance.updateBook(book);
		}
		catch(JavaBookException e)
		{
			return Response.status(Status.INTERNAL_SERVER_ERROR).build();
		}


		return Response.ok().build();
	}
	
	@DELETE
	public Response jsonDeleteBook(@PathParam(BookUrl.idName) BookId id)
	{
		JaxbBookInterface instance = new JaxbBookInterface();

		try
		{
			instance.deleteBook(id);
		}
		catch(JavaBookException e)
		{
			if(e.statusCode.equals("23"))
			{
				return Response.noContent().build();
			}
			else
			{
				return Response.status(Status.INTERNAL_SERVER_ERROR).build();
			}
		}

		return Response.ok().build();
	}
}
