/****************************************************************************
 *
 *   Copyright (C) Micro Focus IP Development Limited  1984-2011. 
 *   All rights reserved.
 *
 *   The software and information contained herein are proprietary to, and
 *   comprise valuable trade secrets of, Micro Focus IP Development Limited, 
 *   which intends to preserve as trade secrets such software and 
 *   information. This software is an unpublished copyright of Micro Focus  
 *   and may not be used, copied, transmitted, or stored in any manner.  
 *   This software and information or any other copies thereof may not be
 *   provided or otherwise made available to any other person.
 *   
 *   $Id: mf.eclipse.codetemplates.xml 357473 2010-01-07 17:15:13Z niy $
 ****************************************************************************/

package com.microfocus.book.rest;

import java.util.regex.Pattern;

public class BookId
{
	public final String id;
	public static final String idRegExStr = "\\d\\d\\d\\d";
	public static final Pattern idRegEx = Pattern.compile(idRegExStr);
	
	public BookId(String id)
	{
		if(!idRegEx.matcher(id).matches())
		{
			throw new RuntimeException("Input string is not an ID!");
		}
		
		this.id = id;
	}
	
	public String toString()
	{
		return this.id;
	}
	
	public boolean equals(Object obj)
	{
		return obj instanceof BookId ? equals((BookId) obj) : false;
	}
	
	public boolean equals(BookId rhs)
	{
		return id.equals(rhs.id);
	}
}
