var currentBook;
var bookLinks = {};

$('#btnRead').click(function() {
	//console.log('btnRead.click');
	var id = $('#stockno').val();
	readById(id);
	return false;
});

$('#btnAdd').click(function() {
	//console.log('btnAdd.click');
	addBook();
	return false;
});

$('#btnDelete').click(function() {
	//console.log('btnDelete.click');
	var id = $('#stockno').val();
	deleteBookById(id);
	return false;
});

$('#btnNext').click(function() {
	//console.log('btnNext.click');
	
	if(bookLinks.next != null)
	{
		readByUrl(bookLinks.next);
	}
	else
	{
		outputMessage("No next book!");
	}
	return false;
});

$('#btnPrev').click(function() {
	//console.log('btnPrev.click');
	
	if(bookLinks.prev != null)
	{
		readByUrl(bookLinks.prev);
	}
	else
	{
		outputMessage("No previous book!");
	}
	return false;
});

function readById(id) {
	readByUrl(baseURL + '/' + id);
}


function readByUrl(url, postfunc) {
	$.ajax({
		type: 'GET',
		url: url,
		dataType: "json",
		success: function(book, a, b){
			//console.log('readById success');
			unpackBook(book);
			renderBook(currentBook);
			if(postfunc != null)
			{
				postfunc();
			}
		},
	    error: function (e) {
	    	//console.log('readById error');
	    }
	});
}

function deleteBookById(id) {
	//console.log('deleteBookById');
	$.ajax({
		type: 'DELETE',
		url: baseURL + '/' + id,
		success: function(data, status, jqXHR){
			alert('Book deleted successfully');
		},
		error: function(e){
			//console.log('deleteBookById error');
		}
	});
}

function addBook() {
	//console.log('addBook');
	var book = bookFromForm();
	var url = baseURL + '/' + $('#stockno').val();
	$.ajax({
		type: 'PUT',
		contentType: 'application/json',
		url: url,
		dataType: "json",
		data: book,
		success: function(data, status, jqXHR){
			alert('Book added successfully');
		},
		error: function(jqXHR, status, error){
			outputMessage('addBook error:' + status);
		}
	});
	
	readByUrl(url);
}

function unpackBook(book) {
	currentBook = book.bookdata;
	var links = book.links;
	for(var i = 0; i < links.length; i++)
	{
		parseLink(links[i], bookLinks);
	}
}

function renderBook(book) {
	$('#stockno').val(book.stockno);
	$('#isbn').val(book.isbn);
	$('#title').val(book.title);
	$('#author').val(book.author);
	$('#type').val(book.type);
	$('#price').val(book.price);
	$('#onhand').val(book.onhand);
	$('#sold').val(book.sold);
	$('#stockval').val(book.stockval);
}

function bookFromForm() {
	return JSON.stringify({
		"stockno": $('#stockno').val(),
		"isbn": $('#isbn').val(),
		"title": $('#title').val(),
		"author": $('#author').val(),
		"type": $('#type').val(),
		"price": $('#price').val(),
		"onhand": $('#onhand').val(),
		"sold": $('#sold').val()
		});
}

function outputMessage(msg) {
	//console.log("Message output:" + msg);
	$('#title').val(msg);
}