var curCollectionURL = baseURL;

var collectionData;
var collectionLinks = {};
var COL_SELECTOR = '#collectionLinks';
var COL_LINK_CLASS = 'collectionLink';
var COL_LINK_SELECTOR = '.' + COL_LINK_CLASS;
var LINK_CLOSE_TAG = "</a>";
var LINE_BREAK="<br class=\"" + COL_LINK_CLASS + "\"/>";

$('#btnNextCol').click(function() {
	curCollectionURL = collectionLinks.next;
	readCollection(curCollectionURL);
	
	return false;
});

$('#btnPrevCol').click(function() {
	curCollectionURL = collectionLinks.prev;
	readCollection(curCollectionURL);
	
	return false;
});

function initialiseCollections() {
	readCollection(curCollectionURL);
}

function readCollection(url) {
	$.ajax({
		type: 'GET',
		url: url,
		dataType: "json",
		success: function(collection, a, b){
			unpackCollection(collection);
			renderCollection(collectionData);
			readById(collectionData[0].bookdata.stockno);
		},
	    error: function (e) {
	    	//console.log('readById error');
	    }
	});
}

function unpackCollection(collection) {
	collectionData = collection.data;
	var links = collection.links;
	for(var i = 0; i < links.length; i++)
	{
		parseLink(links[i], collectionLinks);
	}
}

function renderCollection(collection) {
	clearCollection();
	var i = 0;
	
	for(i = 0; i < collection.length; i++)
	{
		var link = createCollectionLink(collection[i]);
		var lineBreak = $(LINE_BREAK);
		link.appendTo(COL_SELECTOR);
		lineBreak.appendTo(COL_SELECTOR);
	}
	
	for(; i < 5; i++)
	{
		var lineBreak = $(LINE_BREAK);
		lineBreak.appendTo(COL_SELECTOR);
	}
	
	registerLinkEventHandlers();
}

function clearCollection() {
	$(COL_LINK_SELECTOR).remove();
}

function createCollectionLink(book) {
	var href = getLink("self", book.links);
	var content = createCollectionLinkContent(book.bookdata);
	var elementString = linkOpenTag(href) + content + LINK_CLOSE_TAG;
	
	return $(elementString);
}

function linkOpenTag(href) {
	return "<a href=\"" + href +"\" class=\"" + COL_LINK_CLASS +"\">";
}

function createCollectionLinkContent(book) {
	return book.stockno + ": " + book.title + " - " + book.author;
}

function registerLinkEventHandlers() {
	$(COL_LINK_SELECTOR).click(function() {
		readByUrl(this, function() {
			singleBookView();
		});
		return false;
	});
}