************************************************************************
*
*       Copyright (C) Micro Focus 1984-2015. All rights reserved.
*       All rights reserved.
*
************************************************************************
       Program-id. bookwrite.

       Environment division.
       input-output section.
       file-control.
           copy "FDbook.cpy".

       Data division.
       File section.
           FD bookfile is external.
           copy "RDbook.cpy" replacing ==(prefix)== by ==b==.

       working-storage section.
       01 ws-file-status pic xx.
       01 ws-rec-length  pic x(4) comp-5.
       01 ws-call-status pic x(2) comp-5.

       linkage section.
       01 lnk-file-status pic xx.
       copy "RDbook.cpy" replacing ==(prefix)== by ==lnk-b==.

       procedure division using lnk-b-details
                                lnk-file-status.

           move length of lnk-b-details to ws-rec-length

           call "CBL_TOUPPER" using lnk-b-details
                           by value ws-rec-length
                          returning ws-call-status

           open I-O bookfile
           if ws-file-status = "05"
      *>-------File not created yet. any special actions here
               continue
           end-if.

           move lnk-b-isbn  to  b-isbn.
           read bookfile.

           if ws-file-status = "00"
               move "99"  to  ws-file-status
             else
               move lnk-b-title    to  b-title
               move lnk-b-type     to  b-type
               move lnk-b-author   to  b-author
               move lnk-b-date     to  b-date
               move lnk-b-isbn     to  b-isbn
               move lnk-b-stockno  to  b-stockno
               move lnk-b-retail   to  b-retail
               move lnk-b-onhand   to  b-onhand
               move lnk-b-sold   to  b-sold
               write b-details
           end-if

           if ws-file-status <> "00" and ws-file-status <> "02"
               move ws-file-status to lnk-file-status
               close bookfile
               exit program
           end-if

           close bookfile
           move ws-file-status to lnk-file-status

           exit program.
