************************************************************************
*
*       Copyright (C) Micro Focus 1984-2015. All rights reserved.
*       All rights reserved.
*
************************************************************************
       Program-id. bookread.

       Environment division.
       input-output section.
       file-control.
           copy "FDbook.cpy".

       Data division.
       File section.
           FD bookfile is external.
           copy "RDbook.cpy" replacing ==(prefix)== by ==b==.

       working-storage section.
       01 ws-file-status   pic xx.
       01 ws-rec-length    pic x(4) comp-5.
       01 ws-call-status   pic x(2) comp-5.
       01 warningList      pic x(1).
           88 ErrorMe value "1","2","3".

       linkage section.
       01 lnk-file-status pic xx.
       copy "RDbook.cpy" replacing ==(prefix)== by ==lnk-b==.

       procedure division using lnk-b-details lnk-file-status.

           move length of lnk-b-details to ws-rec-length
           call "CBL_TOUPPER" using lnk-b-details
                           by value ws-rec-length
                          returning ws-call-status

           open input bookfile
           if ws-file-status <> "00"
               initialize lnk-b-details
               move all '*' to lnk-b-text-details
               move ws-file-status to lnk-file-status
               exit program
           end-if

           move lnk-b-isbn    to b-isbn
           move lnk-b-stockno to b-stockno
           move lnk-b-title   to b-title
           move lnk-b-author  to b-author

           evaluate true
           when b-isbn <> spaces
               read bookfile
           when b-stockno <> spaces
               read bookfile key is b-stockno
           when b-title <> spaces
               read bookfile key is b-title
           when b-author <> spaces
               read bookfile key is b-author
           when other *>----No key specified - return failed read ---*
              move "23" to ws-file-status
           end-evaluate.

           move ws-file-status to lnk-file-status

           close bookfile

           if lnk-file-status <> "00"
               initialize lnk-b-details
               move all '*' to lnk-b-text-details
               exit program
           end-if

           move b-title   to lnk-b-title
           move b-type    to lnk-b-type
           move b-author  to lnk-b-author
           move b-date    to lnk-b-date
           move b-isbn    to lnk-b-isbn
           move b-stockno to lnk-b-stockno
           move b-retail  to lnk-b-retail
           move b-onhand  to lnk-b-onhand
           move b-sold    to lnk-b-sold

     **>----- file-status will be '00' unless close failed
           move ws-file-status to lnk-file-status

           exit program.
