      *-------------------------------------------------------------------------*
      *                        MultiForms Demo                                  *
      *                                                                         *
      *  This example demonstrates how multiple Windows forms can be used within*
      *  a .NET WinForm application.                                            *
      *                                                                         *
      *  The main form Form1 is created in main.cbl. Form1 contains a number of *
      *  button controls which allow you to create two additional forms called  *
      *  Form2 and Form3. Once these forms are created you can click additional *
      *  buttons to control whether they sould be hidden or shown.              *
      *                                                                         *
      *  An event handler is added to Form1 in order to capture the FormClosed  *
      *  event for both Form2 and Form3 so that Form1 can enable and disable the*
      *  correct buttons to allow for a new instance of Form2 or Form3 to be    *
      *  created. The FormClose event is triggered by clicking on the Close Form*
      *  button on Form2 or Form3.                                              *
      *-------------------------------------------------------------------------* 
       class-id MultiFormsDemo.Form1 is partial
                 inherits type System.Windows.Forms.Form.
       
       working-storage section.
       01 Form2    type MultiFormsDemo.Form2.
       01 Form3    type MultiFormsDemo.Form3.
       method-id NEW.
       procedure division.
           invoke self::InitializeComponent
           goback.
       end method.

       method-id btnCreate2_Click final private.
       procedure division using by value sender as object e as type System.EventArgs.
           set Form2 to new type MultiFormsDemo.Form2
           
      *>  The following adds an event handler to this form which will catch the FormClosed event on Form2     
           invoke Form2::add_FormClosed(new System.Windows.Forms.FormClosedEventHandler(self::Form2_Closed))
           invoke Form2::Show
          
      *>  Disable the Create Form2 button so only one instance of Form2 will be created.     
           set self::btnCreate2::Enabled to false
           set self::btnHide2::Enabled to true
           set self::btnShow2::Enabled to true
       end method.

       method-id btnCreate3_Click final private.
       procedure division using by value sender as object e as type System.EventArgs.
           set Form3 to new type MultiFormsDemo.Form3
           
      *>  The following adds an event handler to this form which will catch the FormClosed event on Form3     
           invoke Form3::add_FormClosed(new System.Windows.Forms.FormClosedEventHandler(self::Form3_Closed))
           invoke Form3::Show
      *>  Disable the Create Form3 button so only one instance of Form3 will be created.          
           set self::btnCreate3::Enabled to false
           set self::btnHide3::Enabled to true
           set self::btnShow3::Enabled to true
       end method.

       method-id btnHide2_Click final private.
       procedure division using by value sender as object e as type System.EventArgs.
           invoke Form2::Hide
       end method.

       method-id btnHide3_Click final private.
       procedure division using by value sender as object e as type System.EventArgs.
           invoke Form3::Hide
       end method.

       method-id btnShow2_Click final private.
       procedure division using by value sender as object e as type System.EventArgs.
           invoke Form2::Show
       end method.

       method-id btnShow3_Click final private.
       procedure division using by value sender as object e as type System.EventArgs.
           invoke Form3::Show
       end method.

       method-id Form1_Load final private.
       procedure division using by value sender as object e as type System.EventArgs.
      *> set the initial state of the buttons. 
           set self::btnCreate2::Enabled to true
           set self::btnHide2::Enabled to false
           set self::btnShow2::Enabled to false
           
           set self::btnCreate3::Enabled to true
           set self::btnHide3::Enabled to false
           set self::btnShow3::Enabled to false
                  
       end method.
      *> The following event handler will be triggered when the Close Form2 button is clicked in Form2 
       method-id Form2_Closed.
       procedure division using by value sender as object e as type System.Windows.Forms.FormClosedEventArgs.
           set self::btnCreate2::Enabled to true
           set self::btnHide2::Enabled to false
           set self::btnShow2::Enabled to false
       end method.
      *> The following event handler will be triggered when the Close Form3 button is clicked in Form3
       method-id Form3_Closed.
       procedure division using by value sender as object e as type System.Windows.Forms.FormClosedEventArgs.
           set self::btnCreate3::Enabled to true
           set self::btnHide3::Enabled to false
           set self::btnShow3::Enabled to false
       end method.
       method-id Form2_Load final private.
       procedure division using by value sender as object e as type System.EventArgs.
                  
       end method.
       method-id button1_Click final private.
       procedure division using by value sender as object e as type System.EventArgs.
          invoke self::Close
       end method.

       end class.
