package itso.cics.porder;

import com.ibm.wsif.format.jca.WSIFFormatPartImpl;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.w3c.dom.Element;

public class OrderDetails extends WSIFFormatPartImpl
{
  public OrderDetails()
  {
    addElement("isbn", java.lang.String.class);
    addElement("copies", java.lang.Integer.class);
    addElement("order__status", java.lang.String.class);
    addElement("confirmation", java.lang.String.class);
    addElement("supplier", java.lang.String.class);
  }

  public String getIsbn()
  {
    return (String)this.basicGet("isbn", 0);
  }

  public void setIsbn(String isbn)
  {
    this.basicSet("isbn", 0, isbn);
  }

  public int getCopies()
  {
    Integer result = (Integer)this.basicGet("copies", 0);
    return result == null ? 0 : result.intValue();
  }

  public void setCopies(int copies)
  {
    this.basicSet("copies", 0, new Integer(copies));
  }

  public String getOrder__status()
  {
    return (String)this.basicGet("order__status", 0);
  }

  public void setOrder__status(String order__status)
  {
    this.basicSet("order__status", 0, order__status);
  }

  public String getConfirmation()
  {
    return (String)this.basicGet("confirmation", 0);
  }

  public void setConfirmation(String confirmation)
  {
    this.basicSet("confirmation", 0, confirmation);
  }

  public String getSupplier()
  {
    return (String)this.basicGet("supplier", 0);
  }

  public void setSupplier(String supplier)
  {
    this.basicSet("supplier", 0, supplier);
  }

}


