package com.ibm.ie.reeng.rt.servletserv;

import java.sql.SQLException;
import java.sql.Connection;
import java.sql.Statement;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

import com.ibm.ie.reeng.rt.common.Log;
import com.ibm.ie.reeng.rt.common.Sqlca;
import com.ibm.ie.reeng.rt.common.Config;

import javax.transaction.UserTransaction;
import javax.transaction.Status;

import javax.transaction.*;

/**
 * A placeholder class so the runtime will compile independently of any
 * particular generator output.  Usually the generator tool will
 * generate this.
 */
public class State
{
    private static String defaultDsName = "jdbc/serverdb";

    private Sqlca sqlca = new Sqlca();
    private String userName;
    private String password;
    private Connection con;
    private UserTransaction tran;


    public State()
    {
    }

    public void close()
    {
        commit();
        try
        {
            if (con != null && !con.isClosed())
            {
                    con.close();
            }
        }
        catch (SQLException e)
        {
                Log.exception(e);
        }
    }
   
    public Sqlca getSqlca() { return sqlca; }

    public void setupTransaction()
    {
        try
        {
            InitialContext context=new InitialContext();

            // The following jndi location should be standard for
            // retrieving the UserTransaction
            tran=(UserTransaction)context.lookup("java:/comp/UserTransaction");

            if (tran==null)
                Log.fatalError(this, "Unable to retrieve UserTransaction");
        }
        catch (Exception e)
        {
            Log.exception(e);
        }
    }

    public Connection getConnection()
    {
        if (tran==null)
            setupTransaction();
        
        // First see if we have an open transaction
        try
        {
            //Log.output("getConnection() called.  Transaction status is "+tran.getStatus()+"\n");
            if (tran.getStatus()==Status.STATUS_NO_TRANSACTION ||
                tran.getStatus()!=Status.STATUS_ACTIVE)
            {
                tran.begin();
            }
        }
        catch (javax.transaction.SystemException e)
        {
            Log.fatalException(e);
        }
        catch (javax.transaction.NotSupportedException e)
        {
            Log.fatalException(e);
        }
        
        try
        {
            if (con != null && !con.isClosed()) return con;
            
            InitialContext ic = new InitialContext();

            // See if an env entry exists specifying a datasource name
            String dsName=(String)Config.instance().getString("db.datasource");
            if (dsName == null)
                dsName = defaultDsName;
            else
                dsName = (new StringBuffer("java:comp/env/jdbc/").append(dsName)).toString();
            
            DataSource ds = (DataSource)ic.lookup(dsName);

            // Now, retrieve the db username and password
            userName=(String)Config.instance().getString("db.username");
            if (userName == null)
                userName="";

            password=(String)Config.instance().getString("db.password");
            if (password == null)
                password="";

            con = ds.getConnection(userName, password);

            // Some platforms seem to have a problem with setAutoCommit(false) so
            // look up an environment entry to see if we are to perform it
            boolean setAutoCommitFalse=(boolean)Config.instance().getBoolean("db.setautocommitfalse");
            if (setAutoCommitFalse)
                con.setAutoCommit(false);

            String initialSQL
                = Config.instance().getString("db.startupsql");

            if (initialSQL != null && !initialSQL.trim().equals(""))
            {
                //Log.information(this, "executing startup SQL: " + initialSQL);

                Statement statement = con.createStatement();
                statement.executeUpdate(initialSQL);

                //Log.information(this, "startup SQL successfully executed.");
            }
        }
        catch (Exception e)
        {
            Log.fatalException(e);
        }
        return con;
    }


    public void commit()
    {
        try
        {
            //Log.output("Commiting transaction..");
            tran.commit();
            //Log.output("Commited\n");
        }
        catch (HeuristicRollbackException e)
        {
            Log.fatalException(e);
        }
        catch (RollbackException e)
        {
            Log.fatalException(e);
        }
        catch (SystemException e)
        {
            Log.fatalException(e);
        }
        catch (HeuristicMixedException e)
        {
            Log.fatalException(e);
        }
    }
    
    public void rollback()
    {
        try
        {
            //Log.output("Rolling back transaction..\n");
            tran.rollback();
            //Log.output("Rolled back\n");
        }
        catch (SystemException e)
        {
            Log.fatalException(e);
        }
    }
    
    public void beginTransaction()
    {
        try
        {
            //Log.output("Beginning transcation..\n");
            tran.begin();
            //Log.output("Rolled back\n");
        }
        catch (NotSupportedException e)
        {
            Log.fatalException(e);
        }
        catch (SystemException e)
        {
            Log.fatalException(e);
        }
    }
}
