package com.ibm.ie.reeng.rt.servlet.component;

import com.ibm.ie.reeng.rt.common.view.SetWindowTitleExI;
import com.ibm.ie.reeng.rt.common.view.SetWindowTitleExO;
import com.ibm.ie.reeng.rt.servlet.SystemComponent;
import com.ibm.ie.reeng.rt.servlet.SessionData;

/**
 * Note: SetWindowTitleEx allows you under HPS to set longer window
 * titles than was possible with SetWindowTitle. Under Java
 * SetWindowTitle has no length restriction so SetWindowTitleEx just
 * invokes it.
 */
public class SetWindowTitleEx extends SystemComponent
{
    /** Output view. */
    public SetWindowTitleExO out = new SetWindowTitleExO();

    protected void clearOutputView() { out.clear(); }


    /** Input view. */
    public SetWindowTitleExI in = new SetWindowTitleExI();

    public void clearInputView() { in.clear(); }


    private SetWindowTitle setWindowTitle = new SetWindowTitle();


    protected void execute(SessionData sessionData)
    {
        setWindowTitle.in.captionText = in.caption;
        setWindowTitle.in.titleLength = in.captionLength;

        setWindowTitle.use(sessionData);

        out.returnCode = setWindowTitle.out.returnCode;
    }
}
