package com.ibm.ie.reeng.rt.servlet.component;

import com.ibm.ie.reeng.rt.common.set.ReturnCodes;
import com.ibm.ie.reeng.rt.common.view.SetItemTextI;
import com.ibm.ie.reeng.rt.common.view.SetItemTextO;
import com.ibm.ie.reeng.rt.servlet.SystemComponent;
import com.ibm.ie.reeng.rt.servlet.SessionData;
import com.ibm.ie.reeng.rt.servlet.HtmlToken;
import com.ibm.ie.reeng.rt.servlet.JSPComponent;

import java.util.ArrayList;

public class SetItemText extends SystemComponent
{
    /** Input view. */
    public SetItemTextI in = new SetItemTextI();

    public void clearInputView() { in.clear(); }


    /** Output view. */
    public SetItemTextO out = new SetItemTextO();

    protected void clearOutputView() { out.clear(); }


    public final static String TYPE = "ITEM_TEXT";


    private static class JspData extends JSPComponent
    {
        private String identifier, text;


        public JspData(String identifier, String text)
        {
            this.identifier = identifier;
            this.text = text;
        }

        public ArrayList use(ArrayList htmlList, String guiType)
        {                        
            HtmlToken htmlToken;

            for(int i=0; i<htmlList.size(); i++)
            {
                htmlToken = (HtmlToken)htmlList.get(i);
            
                String tag = htmlToken.getTag();
            
                //valueTag = temp tag used to identify label text and href text
                if( tag.equals("value") || tag.equals("valueTag"))
                {   
                
                    String value;
                    
                    if(guiType.equals(JSPComponent.BUTTON) || guiType.equals(JSPComponent.INPUT))
                        value = "\"" + text + "\"";
                    else
                        value = new String(text);
                                      
                    htmlToken.setValue(value);
                    break; //end for loop
                }
            }
        
            return htmlList;
        }
    }


    public void execute(SessionData sessionData)
    {
    
        sessionData.jsp.addComponent(in.hpsItemId,
                         new JspData(in.hpsItemId,
                                      in.hpsItemText),
                         TYPE);
            
        out.returnCode = ReturnCodes.SUCCESS;
    }
}
