package com.ibm.ie.reeng.rt.servlet.component;

import com.ibm.ie.reeng.rt.common.Log;
import com.ibm.ie.reeng.rt.servlet.JSPComponent;
import com.ibm.ie.reeng.rt.common.set.ReturnCodes;
import com.ibm.ie.reeng.rt.common.set.WindowObjectModes;
import com.ibm.ie.reeng.rt.common.view.SetFieldModeI;
import com.ibm.ie.reeng.rt.common.view.SetFieldModeO;
import com.ibm.ie.reeng.rt.servlet.SystemComponent;
import com.ibm.ie.reeng.rt.servlet.SessionData;

import java.util.ArrayList;

public class SetFieldMode extends SystemComponent
{
    /** Output view. */
    public SetFieldModeO out = new SetFieldModeO();

    protected void clearOutputView() { out.clear(); }


    /** Input view. */
    public SetFieldModeI in = new SetFieldModeI();

    public void clearInputView() { in.clear(); }


    public final static String TYPE = "FIELD_MODE";


    public static class JspData extends JSPComponent
    {
        private int mode;

        public JspData(int mode) { this.mode = mode; }

        public ArrayList use(ArrayList htmlList, String guiType)
        {
            return htmlList;

            //still to do
/*
            setModeMultiple(
                dialog.findChildrenByClass(TransmuteTextField.class, false));

            setModeMultiple(
                dialog.findChildrenByClass(TransmuteComboBox.class, false));
*/
        }
/*
        private void setModeMultiple(java.awt.Component[] components)
        {

            boolean visible = mode != WindowObjectModes.INVISIBLE;
            boolean enabled = mode != WindowObjectModes.VISIBLE_DISABLED;

            for (int i = 0; i < components.length; i++)
            {
                components[i].setVisible(visible);
                components[i].setEnabled(enabled);
            }
        }
 */
    }


    /**
     * Note that there are special cases if fieldLongName is "*EDIT" or
     * "*TEXT". 
     */
    protected void execute(SessionData sessionData)
    {
        in.dump();

        if (in.fieldLongName.equals("*EDIT"))
        {
        
            sessionData.jsp.addComponent(in.fieldLongName,
                             new JspData(in.fieldMode),
                             TYPE);
                                    
        }
        else if (in.fieldLongName.equals("*TEXT"))
        {
            Log.error(this, "\"*TEXT\" field specifier not supported");
        }
        else
        {

            sessionData.jsp.addComponent(in.fieldLongName,
                             new SetControlModeById.JspData(
                                            in.viewLongName,
                                            in.fieldLongName,
                                            in.fieldMode),
                             SetControlModeById.TYPE);
        }

        out.returnCode = ReturnCodes.SUCCESS;
    }
}
