package com.ibm.ie.reeng.rt.servlet.component;

import com.ibm.ie.reeng.rt.common.Log;
import com.ibm.ie.reeng.rt.common.set.ReturnCodes;
import com.ibm.ie.reeng.rt.common.view.HpsGetEnvironmentO;
import com.ibm.ie.reeng.rt.servlet.SystemComponent;
import com.ibm.ie.reeng.rt.servlet.SessionData;

/**
 * This system component is not fully implemented. It is not possible to
 * build an exhaustive list of Java platforms. Nor are all known Hps
 * values for execmode known. Currently (without confirmation), we think
 * the list includes:
 * <UL>
 * <LI> CICS
 * <LI> IMS
 * <LI> BATCH
 * <LI> UNKNOW
 * <LI> PC DOS
 * <LI> PC OS2
 * <LI> WIN 95
 * <LI> WIN NT
 * <LI> W4
 * <LI> AIX
 * <LI> OS2
 * <LI> WINNT
 * <LI> HP-UX
 * <LI> NCR
 * <LI> OS400
 * <LI> SUNOS
 * <LI> CICS
 * </UL>
 * However these values do not seem to be mutually exclusive. The
 * mapping will have to be tuned/adjusted with experience.
 * <p>
 * A list of values for the Java &quot;os.name&quot; system property
 * was found <A * HREF="http://www.tolstoy.com/samizdat/sysprops.html">here</A>.
 * Obviously this list is also prone to revision and expansion.
 */
public class HpsGetEnvironment extends SystemComponent
{
    private String execmode;
    public HpsGetEnvironment()
    {
        String key = System.getProperty("os.name").toLowerCase();

        if (key.equals("windowsnt")) execmode = "WIN NT";
        else if (key.equals("windows nt")) execmode = "WIN NT";
        else if (key.equals("windows 95")) execmode = "WIN 95";

        // PMA: Added Windows 2000 to list - map it to NT.
        else if (key.equals("windows 2000")) execmode = "WIN NT";
        else if (key.equals("windows2000")) execmode = "WIN NT";
        // End PMA
        else if (key.equals("os/2")) execmode = "PS OS2";
        else if (key.equals("hp-ux")) execmode = "HP-UX";
        else if (key.equals("aix")) execmode = "AIX";
        else if (key.equals("solaris")) execmode = "SUNOS";
        else
        {
            Log.error(this, "unknown platform: " + key);
            execmode = "UNKNOW";
        }
    }

    /**
     * Output view.
     */
    public HpsGetEnvironmentO out = new HpsGetEnvironmentO();

    protected void clearOutputView() { out.clear(); }

    protected void execute(SessionData sessionData) { out.execmode = execmode; }
}
