package com.ibm.ie.reeng.rt.servlet.component;

import com.ibm.ie.reeng.rt.common.Config;
import com.ibm.ie.reeng.rt.common.view.GetBusinessProcessNameO;
import com.ibm.ie.reeng.rt.servlet.SystemComponent;
import com.ibm.ie.reeng.rt.servlet.SessionData;

/**
 * This class is supposed to return the currently running process name.
 * However as rebased clients are often launched as rules this
 * information is retrieved through a system property
 * "business.process".
 * <p>
 * As an example the {@link com.ibm.ie.reeng.rt.common.Launcher} class correctly
 * sets this property before starting the appropriate rule.
 */
public class GetBusinessProcessName extends SystemComponent
{
    /** Output view. */
    public GetBusinessProcessNameO out = new GetBusinessProcessNameO();

    protected void clearOutputView() { out.clear(); }


    protected void execute(SessionData sessionData)
    {
        out.businessProcess =
            Config.instance().getString("business.process");//, "PROCESS");
    }
}
