package com.ibm.ie.reeng.rt.servlet;

import com.ibm.ie.reeng.rt.common.HpsEventView;
import com.ibm.ie.reeng.rt.common.Log;
import com.ibm.ie.reeng.rt.servlet.component.SetControlModeById;
import com.ibm.ie.reeng.rt.servlet.component.SetItemText;
import com.ibm.ie.reeng.rt.servlet.component.SetControlColorById;
import com.ibm.ie.reeng.rt.servlet.component.SetFieldMode;
import com.ibm.ie.reeng.rt.servlet.component.SetMenuModeById;

import java.util.ArrayList;
import java.util.StringTokenizer;

import java.util.HashMap;
import java.util.Iterator;

public abstract class TransmuteJSP
{
    protected HpsEventView hpsEvent;
    
    protected String jspName;
    private String title = null;
    
    private final static int MAX_NO_TABLES = 3;

    private int[] elevatorPosition = new int[MAX_NO_TABLES]; //0
    private boolean[] OOR = new boolean[MAX_NO_TABLES]; //false;  

    protected int[] increment = new int[MAX_NO_TABLES]; // Number of rows onscreen    
    private int[] realOffset = new int[MAX_NO_TABLES]; // 'Real' offset ranging from zero up virtual list box size
    protected int[] offset = new int[MAX_NO_TABLES]; // pageCount times onscreen rows eg. 3x10=30 for the fourth page of ten rows
    protected int[] numberOfRecords = new int[MAX_NO_TABLES]; // Number of records the SQL select has found - only lbSize are available each time however
    protected int[] lbSize = new int[MAX_NO_TABLES]; // Tmp - must be the number of cells in the appropriate LB

    private int[] selectedRow= new int[MAX_NO_TABLES];

    //Hash table to store window dynamic data, visibility, field colour/text etc
    private HashMap tables = new HashMap(); // HashMap of per component HashMaps.
    

    //Listing of html Tag/Value pairs
    ArrayList htmlList;

    //Flag used to make sure html string is only tokenised once.
    //Performance
    boolean htmlTokenised;

    //returned from converse.
    protected String returnString = "";

    //Servlet solution
    public TransmuteJSP(HpsEventView hpsEvent)
    {
        this.hpsEvent=hpsEvent;
        
        //initialise table data
        for(int i=0; i<MAX_NO_TABLES; i++)
        {
            elevatorPosition[i] = 0;
            OOR[i] = false;  
            increment[i] = 10; // Number of rows onscreen    
            realOffset[i] = 0; // 'Real' offset ranging from zero up virtual list box size
            offset[i] = 0; // pageCount times onscreen rows eg. 3x10=30 for the fourth page of ten rows
            numberOfRecords[i] = 0; // Number of records the SQL select has found - only lbSize are available each time however
            lbSize[i] = 0; // Tmp - must be the number of cells in the appropriate LB
            selectedRow[i]=-1;   
        }        
    }

    public String servletConverse(ServletThreadCtrl servletThreadCtrl)
    {
        servletThreadCtrl.ret2Servlet();
        servletThreadCtrl.waitForEvent();

        return returnString;
    }

    
    public void setListBoxSize(int lbSize, int tabIndex)
    {
        this.lbSize[tabIndex] = lbSize;
    }


    public void setNoOfRecords(int numberOfRecords, int tabIndex)
    {
        this.numberOfRecords[tabIndex] = numberOfRecords;
    }


    public void setElevatorPosition(int newPosition, int tabIndex) 
    {
        if (newPosition >= 0)
            elevatorPosition[tabIndex] = newPosition; 
        else
            Log.fatalError(this, "Attempt to set elevator position to negative value.");
    }
    public int getElevatorPosition(int tabIndex) {return elevatorPosition[tabIndex];}

    public void setOOR(boolean state, int tabIndex) { OOR[tabIndex] = state; }
    public boolean getOOR(int tabIndex) { return OOR[tabIndex]; }


    public int getIncrement(int tabIndex) { return increment[tabIndex]; }

    public int getLoopSentinel(int tabIndex)
    {
        if (numberOfRecords[tabIndex] - realOffset[tabIndex] < increment[tabIndex])
            return numberOfRecords[tabIndex]%increment[tabIndex]; // Eg. 41 becomes 1 s.t. only the last row of the table is displayed
        else
            return increment[tabIndex];
    }
  
    public int getLBOffset(int tabIndex) { return realOffset[tabIndex]; }
    public void resetLBOffset(int resetValue, int tabIndex) { offset[tabIndex] = resetValue; };
  
    public void setLBOffset(int num, int tabIndex)
    { 
        if (num > 0) // Going forward
        {
            offset[tabIndex] += num;
            realOffset[tabIndex] += num;

            if (offset[tabIndex] >= lbSize[tabIndex]) // we must get next chunk of data from Backend - what about going back??
            {
                setElevatorPosition(realOffset[tabIndex], tabIndex);
                resetLBOffset(0, tabIndex); //So that we start from the beginning of the new 'data window'
                setOOR(true, tabIndex);
            }
        }
        else if (num < 0) // In reverse
        {
            offset[tabIndex] += num; // Must be set b4 the IF clause as it may get set to an incorrect value if called afterwards

            if (realOffset[tabIndex]%lbSize[tabIndex] == 0) //if we're traversing a LB boundary then we need an OOR event
            {        
                setElevatorPosition(realOffset[tabIndex] - lbSize[tabIndex], tabIndex); // Step 'data window' back lbSize rows
                resetLBOffset(lbSize[tabIndex] - increment[tabIndex], tabIndex);
                setOOR(true, tabIndex);
            }     

            realOffset[tabIndex] += num;
        }
        else
        {
            Log.fatalError(this, "Invalid increment specified: " + num);
        }
    }



    public int getSelectedRow(int tabIndex)
    {
        return selectedRow[tabIndex];
    }
    

    public String isRowSelected(int row, int tabIndex)
    {
        if (selectedRow[tabIndex] == (realOffset[tabIndex] + row))
            return "checked";
        else
            return "";
    }
    

    public void setSelectedRow(String row, int tabIndex) 
    {
        selectedRow[tabIndex] = Integer.valueOf(row).intValue();
    }

    public void setFirstVisibleRow(int row, int tabIndex)
    {
        selectedRow[tabIndex] = row;
    }


    public void resetSelectedRow(int tabIndex)
    {
        setSelectedRow("-1", tabIndex);
    }

    protected void setIncrement(int value, int tabIndex)
    {
        increment[tabIndex] = value;
    }


    public String isDisabled(String itemID, int tabIndex) 
    { 
        if (itemID.equals("PREV0") && realOffset[tabIndex] == 0 && tabIndex == 0)
            return "DISABLED";
        else if (itemID.equals("NEXT0") && ((numberOfRecords[tabIndex] - realOffset[tabIndex]) < increment[tabIndex]) && tabIndex == 0)
            return "DISABLED";
        else if (itemID.equals("PREV1") && realOffset[tabIndex] == 0 && tabIndex == 1)
            return "DISABLED";
        else if (itemID.equals("NEXT1") && ((numberOfRecords[tabIndex] - realOffset[tabIndex]) < increment[tabIndex]) && tabIndex == 1)
            return "DISABLED";
        else
            return "";
    };


    public String getNextJSP()
    {
        return jspName;
    }



    public void setHpsEvent(String name, String srcEvent, String qualifier)
    {
        returnString = new String(srcEvent);
        
        if(hpsEvent != null)
        {
    
            hpsEvent.eventName         = name;
            hpsEvent.eventSource     = srcEvent;
            hpsEvent.eventQualifier    = qualifier;
            hpsEvent.eventView         = "";
            hpsEvent.eventParam     = "";

            //check for window/rule event exceptions        
            setEvtQualifier();
            setEvtName();
        }
    }

    protected abstract void setEvtQualifier();
    protected abstract void setEvtName();


    //Details of the system components are stored in HashMaps, where 
    //each system component is assoicated with a unique HashMap.
    public HashMap getComponentTable(String component)
    {
        HashMap componentTable = (HashMap)tables.get(component);

        if (componentTable == null)
        {
            componentTable = new HashMap();
            tables.put(component, componentTable);
        }

        return componentTable;
    }


    //Add details of component to the component's HashTable    
    public void addComponent(String hpsId, JSPComponent jspData, String compType)
    {
        HashMap componentTable = getComponentTable(compType);

        if (componentTable.put(hpsId, jspData) != null)
            Log.warning(this, hpsId + " names more than one " +
                compType);
    }



    //Investigate if the html string needs to be modified due to
    //modification of system components within the rule logic
    public void parseHtml(String hpsId, String component, String html, String guiType)
    {
        HashMap componentTable = getComponentTable(component);

        JSPComponent jspComp = (JSPComponent)componentTable.get(hpsId);

        if(jspComp!=null)
        {
            //The HTML string is only tokenised if part of the string 
            //needs to be dynamically updated.
            if(!htmlTokenised)
                tokeniseHtml(html);
        
            htmlList = jspComp.use(htmlList, guiType);
        }
    }


    //Remove system component details.
    public void clearCompData()
    {
        Iterator iterator = tables.values().iterator();

        while (iterator.hasNext())
        {
            ((HashMap)iterator.next()).clear();
        }
    }


    public void setTitle(String title) { this.title = title; }  
    
    public String getTitle(String inTitle) 
    { 
        if(title != null)
            return title; 
        else
            return inTitle;
    }


    public String getMenuHtml(String hpsId, String html)
    {
        //html string hasn't been tokenised yet.
        htmlTokenised = false;
            
//CLEARORDER ,&nbsp;&nbsp;<a href="" onClick="setSourceEvent('Order');">Order</a>
        
        //check if visible/enabled
        parseHtml(hpsId, SetMenuModeById.TYPE, html, JSPComponent.MENU);

        //check for text
        parseHtml(hpsId, SetItemText.TYPE, html, JSPComponent.MENU);

        //Set the colour
        parseHtml(hpsId, SetControlColorById.TYPE, html, JSPComponent.MENU);

        return constructHtml(html);
    }

    public String getImageHtml(String hpsId, String html)
    {
        //html string hasn't been tokenised yet.
        htmlTokenised = false;

        //check if visible
        parseHtml(hpsId, SetControlModeById.TYPE, html, JSPComponent.IMAGE);
    
        return constructHtml(html);
    }


    public String getLabelHtml(String hpsId, String html)
    {

        //html string hasn't been tokenised yet.
        htmlTokenised = false;

//ID00159, Selected Deal

        //check if visible
        parseHtml(hpsId, SetControlModeById.TYPE, html, JSPComponent.LABEL);

        //check for text
        parseHtml(hpsId, SetItemText.TYPE, html, JSPComponent.LABEL);

        //check for text colour
        parseHtml(hpsId, SetControlColorById.TYPE, html, JSPComponent.LABEL);
        
        return constructHtml(html);
    }
    

    
    public String getInputHtml(String hpsId, String html)
    {
        //html string hasn't been tokenised yet.
        htmlTokenised = false;

//STATUS, <input type="Button" value="Deal Status" name="STATUS" onClick="setSourceEvent('STATUS')" >&nbsp;&nbsp;
        
        String compType;


        if(html.indexOf("type=\"Button\"") != -1)
            compType = JSPComponent.BUTTON;
        else
            compType = JSPComponent.INPUT;
                    

        //check if visible/enabled
        parseHtml(hpsId, SetControlModeById.TYPE, html, compType);

        //check for text
        parseHtml(hpsId, SetItemText.TYPE, html, compType);

        //check for text colour
        parseHtml(hpsId, SetControlColorById.TYPE, html, compType);

        return constructHtml(html);
    }



    public String getRadioHtml(String hpsId, String html)
    {
        //html string hasn't been tokenised yet.
        htmlTokenised = false;

//ID00159, Selected Deal

        //check if visible
        parseHtml(hpsId, SetControlModeById.TYPE, html, JSPComponent.RADIO);

        //check for text
        parseHtml(hpsId, SetItemText.TYPE, html, JSPComponent.RADIO);

        //check for text colour
        parseHtml(hpsId, SetControlColorById.TYPE, html, JSPComponent.RADIO);
        
        return constructHtml(html);
    }

    
    public String radioChecked(String hpsId, String checkedHpsId, boolean groupStart)
    {
        if(hpsId.equals(checkedHpsId))
            return "checked";
        else if(checkedHpsId.equals("") && groupStart)
            return "checked";
        else
            return "";        
    }


    public String getGroupBoxHtml(String hpsId, String html)
    {
        //html string hasn't been tokenised yet.
        htmlTokenised = false;

        //check if visible
        parseHtml(hpsId, SetControlModeById.TYPE, html, JSPComponent.GROUPBOX);

        
        return constructHtml(html);
    }

    
    public String getGroupBoxTextHtml(String hpsId, String html)
    {
        //html string hasn't been tokenised yet.
        htmlTokenised = false;

        //check if visible
        parseHtml(hpsId, SetControlModeById.TYPE, html, JSPComponent.GROUPBOX);

        //check for text
        parseHtml(hpsId, SetItemText.TYPE, html, JSPComponent.GROUPBOX);
        
        return constructHtml(html);
    }




    private void tokeniseHtml(String html)
    {
        //Using default white space delimiters " \n\t etc" 
        StringTokenizer tokenizer = new StringTokenizer(html);

        htmlTokenised = true;
    
        htmlList = new ArrayList();


        while (tokenizer.hasMoreTokens())
        {
            htmlList.add(new HtmlToken(tokenizer.nextToken()));
        }
    }

    
    private String constructHtml(String html)
    {

        //Reconstruct the html string if tokenised, 
        //ie if it was dynamically updated
        if(htmlTokenised)
        {
        
            StringBuffer htmlBuf = new StringBuffer();


            for(int i=0; i<htmlList.size(); i++)
            {
                htmlBuf.append(((HtmlToken)htmlList.get(i)).getHtml());
            }

            html = htmlBuf.toString();
        }

        return removeTempValueTags(html);    
    }          


    //Remove temporary tags around label and href text values
    //This enabled the position of the text strings to be
    //identified and replaced if necessary
    private String removeTempValueTags(String htmlBuf)
    {
        int startIndex = htmlBuf.indexOf(" ^");
        int endIndex = htmlBuf.lastIndexOf("^ ");
        
        
        if(startIndex != -1 || endIndex != -1)
        {
            char[] html = htmlBuf.toCharArray();
            
            char[] temp = new char[html.length];        

            html[startIndex] = '^';
            html[endIndex+1] = '^';
            
            int i, pos=0;
            //ignore '^' characters
            for(i=0; i<html.length; i++)
            {
                if(html[i] != '^')
                {
                    temp[pos++] = html[i];                
                }            
            }                        

            

            return new String(temp).replace('*', ' ').replace('~',' ');        
        }
        
        return htmlBuf.replace('*', ' ').replace('~',' ');        
    }


    //Called from window setData method
    protected int parseSelectedRow(String row, int tabIndex)
    {        
        if(row != null)
        {
            selectedRow[tabIndex] = Integer.valueOf(row).intValue();
            return selectedRow[tabIndex];
        }
 
        return -1;
    }  

    // Chops decimal portion off double primative data types if that decimal portion is all zeros i.e. 500.00 becomes 500
    // Standard Java only chops in down to one zero i.e. 500.00 becomes 500.0
    public static String convertDouble(double number)
    {
        String result = String.valueOf(number);

        boolean chop = true;

        int decPt = result.indexOf(".");

        for (int i = ++decPt; i < result.length(); i++)
        {
            if (result.charAt(i) != '0')
                chop = false;
        }

        if (chop)
            return String.valueOf((int)number);    
        else
            return String.valueOf(number);
    }


}
