package com.ibm.ie.reeng.rt.servlet;

import com.ibm.ie.reeng.rt.common.Log;
import com.ibm.ie.reeng.rt.common.Config;

/**
 * A trivial extension of {@link Component} which overrides {@link
 * #isSystem}.
 */
public abstract class SystemComponent extends Component
{
    /** Always returns true. */
    protected boolean isSystem() { return true; }

    /**
     * This won't be needed once all the system components have been
     * implemented.
     */
    protected void notImplemented()
    {
        String message = "system component not implemented";
        if (nonFatal) Log.error(this.getClass().getName(), message);
        else Log.fatalError(this.getClass().getName(), message);
    }

    private static boolean nonFatal
        = Config.instance().getBoolean("trace.unimplemented.syscomps.nonfatal");
}
