package com.ibm.ie.reeng.rt.ejb;

import com.ibm.ie.reeng.rt.common.LocalRule;
import com.ibm.ie.reeng.rt.common.Log;
import com.ibm.ie.reeng.rt.common.Config;

/**
 * The base class for all generated server classes corresponding to Hps
 * rules.
 * <p>
 * This is a pretty safe place to put the
 * com.ibm.ie.reeng.rt.common.Config setup.
 */
public abstract class ServerRule extends LocalRule
{
    static
    {
        // WARNING: order is important. This code should be executed as
        // early as possible. Hopefully this class should be loaded very
        // early.

        try
        {
            Config.setSource(new ConfigSource());
        }
        catch (javax.ejb.EJBException e)
        {
            // We could be running stand alone
            // Try the default
            Config.instance();
        }
    }

    /**
     * Subclasses must implement one of these to provide the rule logic.
     * Since subclasses only want to implement one of these
     * we'll provide empty implementations here (rather than specify 
     * abstract methods).
     */

    protected void execute(State ctx) { Log.fatalError(this, "execute(State) not defined"); }
    protected void execute() { Log.fatalError(this, "excecute() not defined!"); }

    /**
     * To clear output view, we need access to the
     * server context.  This is a project-specific
     * derivative of State and rules will refer
     * to it with a downcast.
     */
    protected void clearOutputView(State ctx) {}

    private boolean createRules = true;

    /**
     * This is the public interface to the rule. Subclasses implement
     * {@link #execute} but users call this method which creates child
     * rules (see {@link #createChildRules}) if necessary, clears the
     * local variables, the output view and the input views of child
     * rules.
     */
    public void use(State ctx)
    {
        Log.information(this, "entering");

        if (createRules)
        {
            createChildRules();
            createRules = false;
        }

        // Clear relevant views and local variables.
        clearLocalVariables();
        clearOutputView(ctx);
        clearOutputView();
        clearChildInputViews();

        execute(ctx);

        Log.information(this, "exiting");
    }
}
