package com.ibm.ie.reeng.rt.ejb;

import javax.naming.InitialContext;
import javax.naming.Context;
import javax.naming.NamingException;

import com.ibm.ie.reeng.rt.common.Marshall;
import com.ibm.ie.reeng.rt.common.Util;
import com.ibm.ie.reeng.rt.common.comms.CtgComms;

import com.ibm.ctg.client.JavaGateway;
import com.ibm.ctg.client.ECIRequest;

import java.util.Arrays;
import java.net.UnknownHostException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

import javax.ejb.EJBException;



/**
 * This supports invoking CICS rules from enterprise beans.  This
 * requires the CICS Transaction Gateway client library (ctgclient.jar)
 * and the EJB library (in this case j2ee.jar).
 */
public class CtgEjbComms extends CtgComms
{
    
    private static String config;
    
    private Context environment;
    
    public CtgEjbComms(long sessionId,
                       String userName,
                       String password)
    {
        if(!initialised)
        {
            String jgateURL = (String)getEnvEntry("JGate URL");
            String serverName = (String)getEnvEntry("Server Name");
            String routerName = (String)getEnvEntry("Router Name");
            String serverCodepage = (String)getEnvEntry("Server Codepage");
            int commAreaSize = ((Integer)getEnvEntry("COMMAREA Size")).intValue();
            boolean debug = ((Boolean)getEnvEntry("CTG Debug")).booleanValue();

            config =  "[Environment Entries: \"JGate URL\" = " + jgateURL
                    + " \"Server Name\" = " + serverName
                    + " \"Router Name\" = " + routerName
                    + " \"Server Codepage\" = " + serverCodepage
                    + " \"COMMAREA Size\" = " + commAreaSize
                    + " \"CTG Debug\" = " + debug + "]";



            initCtgConfigData(jgateURL,
                              serverName,
                              routerName,
                              commAreaSize,
                              serverCodepage,
                              debug);
        }

     
        initCtgConnection(Long.toString(sessionId),
                          userName,
                          password);
    }



    private Object getEnvEntry(String key)
    {
        if (environment == null)
        {
            try
            {
                Context initial = new InitialContext();
                environment = (Context)initial.lookup("java:comp/env");
            }
            catch (NamingException ex) { fatalException(ex); }
        }

        try { return (String)environment.lookup(key); }
        catch (NamingException ex) { fatalException(ex); }
        return null;
    }


    protected void information(String s)
    {
        System.out.println("CtgEjbComms INFO: " + s);
    }

    protected void requestError(ECIRequest req, String extra)
    {
        information("CtgEjbComms ERROR: CICS Transaction Gateway falure: RC = "
            + req.getCicsRcString() + ". " + extra);
    }

    protected void fatalError(String s)
    {
        throw new EJBException(
            "CtgEjbComms FATAL ERROR " + config + ": " + s);
    }

    protected void fatalException(Exception e)
    {
        throw new EJBException(
            "CtgEjbComms FATAL ERROR " + config + ": " + e.getMessage());
    }
}

