package com.ibm.ie.reeng.rt.common.view;

import com.ibm.ie.reeng.rt.common.Marshall;
import com.ibm.ie.reeng.rt.common.View;

public class SetPopupPositionI extends View
{
    public SetPopupPositionI() { clear(); }
    
	/* poptype is the type of positioning
	 * its attached to the WINDOW_POSITIONS set
	 * 1 = Absolute coordinates (0, 0 is the top left of the screen)
	 * 2 = Relative to the entire window
	 * 3 = Relative to the client area (the panel area inside the window)
	 */
    public int poptype;

    public int topPosition;

    public int leftPosition;

    public final void clear()
    {
        poptype = 0;
        topPosition = 0;
        leftPosition = 0;
    }

    public void writeMembersTo(Marshall m)
    {
        m.writeSmallint(poptype);
        m.writeSmallint(topPosition);
        m.writeSmallint(leftPosition);

    }

    public void readMembersFrom(Marshall m)
    {
        poptype = m.readSmallint();
        topPosition = m.readSmallint();
        leftPosition = m.readSmallint();

    }
}
