package com.ibm.ie.reeng.rt.common.comms;

import com.ibm.mq.MQQueueManager;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQC;
import com.ibm.mq.MQEnvironment;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQGetMessageOptions;


import com.ibm.ie.reeng.rt.common.Log;
import com.ibm.ie.reeng.rt.common.Util;
import com.ibm.ie.reeng.rt.common.Marshall;
import com.ibm.ie.reeng.rt.common.Comms;


public class MqComms implements Comms
{
    private MQQueueManager manager = null;
    private MQQueue inboxQueue, outboxQueue;

    // Default timeout for response from server:
    private int timeoutmsec = MQC.MQWI_UNLIMITED;

    public MqComms()
    {
        try
        {
            MQEnvironment.hostname = System.getProperty("hostname");
            MQEnvironment.channel = System.getProperty("channel",
                "CLIENT.SERVER");
            

            String timeoutString = System.getProperty("timeoutmsec");
            if (timeoutString != null)
            {
                try { timeoutmsec = Integer.parseInt(timeoutString); }
                catch (Exception e)
                {
                    Log.error(this, "timeoutmsec property ("
                        + timeoutString + ") doesn't have a numeric format");
                }
            }

            final String managerName = System.getProperty("manager");
            final String inboxName = System.getProperty("inbox", "INBOX");
            final String outboxName = System.getProperty("outbox", "OUTBOX");
            manager = new MQQueueManager(managerName);

            outboxQueue = manager.accessQueue(outboxName,
                MQC.MQOO_INPUT_AS_Q_DEF, null, null, null);

            inboxQueue = manager.accessQueue(inboxName,
                MQC.MQOO_OUTPUT, null, null, null);

            Log.information(this, "MQ manager and queues created");
        }
        catch (Exception e)
        {
            Log.fatalException(e);
            finalize();
        }
    }

    /**
     * Closes everything.
     */
    public void finalize()
    {
        try { outboxQueue.close(); }
        catch (Exception e) { System.err.println(e); }

        try { inboxQueue.close(); }
        catch (Exception e) { System.err.println(e); }

        try { manager.disconnect(); }
        catch (Exception e) { System.err.println(e); }
    }

    public void send(String ruleName, Marshall marshall)
    {
        try
        {
            String data = marshall.getWriteBuffer();
            StringBuffer buffer = new StringBuffer();

            // Create the message including initial header.
            buffer.append("0"); // Version number.
            buffer.append(Util.padRight(ruleName, 8, Util.SPACE));
            buffer.append(Util.padLeft(Integer.toString(data.length()), 9,
                Util.ZERO)); // Data length.
            buffer.append(data);

            MQMessage request = new MQMessage();
            request.writeString(buffer.toString());
            request.format = MQC.MQFMT_STRING;   // required for data conversion

            MQPutMessageOptions putOptions = new MQPutMessageOptions();

            inboxQueue.put(request, putOptions);

            Log.information(this, "sent MQ message");

            // ----------------------------------------------------------------

            MQMessage response = new MQMessage();
            MQGetMessageOptions getOptions = new MQGetMessageOptions();

            response.messageId = request.messageId;

            getOptions.options = MQC.MQGMO_WAIT + MQC.MQGMO_CONVERT;
            getOptions.waitInterval = timeoutmsec;

            outboxQueue.get(response, getOptions);

            Log.information(this, "received " +
                response.getDataLength() + " bytes");

            StringBuffer header = new StringBuffer();

            // Read off the header.
            for (int i = 0; i < 14; i++)
            {
                if (i != 0) header.append(", ");
                header.append(response.readUnsignedByte());
            }

            Log.information(this, "MQ header was " + header);

            data = response.readString(response.getDataLength());

            marshall.setReadBuffer(data);
        }
        catch (Exception e)
        {
            Log.fatalException(e);
            e.printStackTrace();
            finalize();
        }
    }
}
