package com.ibm.ie.reeng.rt.common;

import java.lang.reflect.Field;
import java.lang.reflect.Array;

/**
 * This class is only to be used as super class. Thus the constructor is
 * protected.
 */
public abstract class View implements java.io.Serializable
{
    protected View() { }


    public void dump()
    {
        try
        {
            Field[] fields = getClass().getFields();

            for (int i = 0; i < fields.length; i++)
                Log.information(this, fields[i] + " = "
                    + fields[i].get(this));
        }
        catch (Exception e)
        {
            Log.fatalException(e);
        }
    }


    // ------------------------------------------------------------------------


    public boolean equals(Object right)
    {
        return equals(this, right);
    }


    //
    // Note: comparisons between views should be done by viewing them
    // simply as sequences of bytes. The routines below will only work
    // if the two views being compared are structurally equal. It cannot
    // do a bytewise comparison of views with different layouts.
    //


    //
    // Note: the code below is very similar to that
    //       found in ClientRule.map().
    //
    protected static boolean equals(Object left, Object right)
    {
        try
        {
            if (left == null || right == null)
                Log.fatalError("View", "cannot compare null objects");

            Class leftClass = left.getClass();
            Class rightClass = right.getClass();

            if (isBasicType(leftClass) && isBasicType(rightClass))
                return left.equals(right);

            if (leftClass.isPrimitive() || rightClass.isPrimitive())
                Log.fatalError("View", "cannot compare primitive type " +
                    leftClass.getName() + " with " + rightClass.getName());

            if (leftClass.isArray() && rightClass.isArray())
            {
                int length = Array.getLength(left);

                if (length != Array.getLength(right))
                    Log.fatalError("View",
                        "cannot compare arrays of unequal length");

                for (int i = 0; i < length; i++)
                {
                    if (!equals(Array.get(left, i), Array.get(right, i)))
                        return false;
                }
            }
            else if (leftClass.isArray() || rightClass.isArray())
                Log.fatalError("View",
                    "cannot compare an array with a non-array");
            else
            {
                Field[] leftFields = leftClass.getFields();
                Field[] rightFields = rightClass.getFields();

                int length = leftFields.length;

                if (length == 0)
                    Log.fatalError("View",
                        "cannot compare objects of type " + leftClass.getName());

                if (length != rightFields.length)
                    Log.fatalError("View",
                        "cannot compare objects which are structurally " +
                        "different");

                for (int i = 0; i < leftFields.length; i++)
                {
                    Field leftField = leftFields[i];
                    String leftName = leftField.getName();

                    Field rightField = rightFields[i];
                    String rightName = rightField.getName();

                    if (!leftName.equals(rightName))
                        Log.fatalError("View", "cannot compare objects "
                            + "with different field names");

                    if (!equals(leftField.get(left), rightField.get(right)))
                        return false;
                }
            }
        }
        catch (Exception e)
        {
            Log.fatalException(e);
        }

        return true;
    }


    private static boolean isBasicType(Class type)
    {
        return type == Integer.class
            || type == Long.class
            || type == Double.class
            || type == String.class
            || type == java.sql.Date.class
            || type == java.sql.Time.class
            || type == java.sql.Timestamp.class;
    }

    public abstract void clear();

    public abstract void writeMembersTo(Marshall m);

    public abstract void readMembersFrom(Marshall m);

    public Marshall writeTo(Marshall m)
    {
        m.viewStart();
        writeMembersTo(m);
        m.viewEnd();
        return m;
    }

    public Marshall readFrom(Marshall m)
    {
        m.viewStart();
        readMembersFrom(m);
        m.viewEnd();
        return m;
    }

    public String toString()
    {
        return Util.toString(this);
    }
}
