package com.ibm.ie.reeng.rt.common;


/**
 * The runtime uses an implementation of the following interface to log
 * events. 
 */
public interface Trace
{
    /**
     * Add a line to the the log.
     */
    public void output(String text);

    /**
     * Log an informational message.
     */
    public void information(Object source, String text);

    /**
     * Log a warning message.
     */
    public void warning(Object source, String text);

    /**
     * Log an error message.
     */
    public void error(Object source, String text);

    /**
     * Log a fatal error and die.
     */
    public void fatalError(Object source, String text);

    /**
     * Log an exception.
     */
    public void exception(Exception e);

    /**
     * Log a fatal exception and die.
     */
    public void fatalException(Exception e);
}
