package com.ibm.ie.reeng.rt.common;

/**
 * An abstract class which provides the basis for a {@link Marshall}
 * class which marshals to a character string.
 */
public abstract class StringMarshall extends Marshall
{
    private StringBuffer writeBuffer = new StringBuffer();


    public String getWriteBuffer()
    {
        checkState(WRITE);

        return writeBuffer.toString();
    }


    protected void put(String element)
    {
        checkState(WRITE);

        writeBuffer.append(element);
    }

    protected void putSpaces(int len)
    {
        checkState(WRITE);

        for (int i = 0; i < len; i++) writeBuffer.append(" ");
    }

    protected int getWriteLength() { return writeBuffer.length(); }


    // ------------------------------------------------------------------------


    private String readBuffer;
    private int position = 0;


    public void setReadBuffer(String buffer)
    {
        checkState(WRITE);

        readBuffer = buffer;

        setReadBufferLength(buffer.length());

        state = READ;
    }


    protected String get(int length)
    {
        if (state == WRITE) setReadBuffer(getWriteBuffer());

        int pad = getPad(readBuffer.length() - position, length);
        int count = length - pad;

        StringBuffer element = new StringBuffer();

        if (count > 0)
            element.append(readBuffer.substring(position, (position + count)));

        for (int i = 0; i < pad; i++)
            element.append(' ');

        position += length;

        return element.toString();
    }


    protected int getReadLength() { return (readBuffer.length() - position); }


    // ------------------------------------------------------------------------


    public void dumpBuffer()
    {
        if (state == WRITE) dumpBuffer(getWriteBuffer());
        else dumpBuffer(readBuffer);
    }
}
