package com.ibm.ie.reeng.rt.common;

import java.io.BufferedReader;
import java.io.FileReader;


/**
 * This class can be used for completely canned server interaction for
 * testing rebased clients.
 * <P>
 * It ignores sent data and simply returns the next block of text that
 * it finds in a file called "script.txt"
 */
public class ScriptComms implements Comms
{
    BufferedReader in;


    public ScriptComms()
    {
        try
        {
            in = new BufferedReader(new FileReader("script.txt"));
        }
        catch (Exception e)
        {
            Log.fatalException(e);
        }
    }


    public void send(String ruleName, Marshall marshall)
    {
        try
        {
            final char ESCAPE = '\\';
            StringBuffer buffer = new StringBuffer();
            char terminator;

            do
            {
                String line = in.readLine();

                if (line == null) break;

                int end = line.length() - 1;

                terminator = line.charAt(end);

                if (terminator == ESCAPE) line = line.substring(0, end);

                buffer.append(line);
            }
            while (terminator == ESCAPE);

            marshall.setReadBuffer(buffer.toString());
        }
        catch (Exception e)
        {
            Log.fatalException(e);
        }
    }
}
