package com.ibm.ie.reeng.rt.common;

import java.text.SimpleDateFormat;




/**
 * This differs from DefaultMarshall by marshalling Dates, Times and
 * Timestamps using the ISO character based format.
 */
public class RelativityMarshall extends DefaultMarshall
{
    private final static int SMALLINT_DIGITS = 5;
    private final static int INTEGER_DIGITS = 10;
    
    
    // these are all initialized below.
    private static String RELATIVITY_DATE_FORMAT;
    private static int RELATIVITY_DATE_FORMAT_LENGTH;
    private static SimpleDateFormat RELATIVITY_DATE;

    //Format for MM/DD/YYYY
    private static String RELATIVITY_DATE_SLASH_FORMAT;
    private static int RELATIVITY_DATE_SLASH_FORMAT_LENGTH;
    private static SimpleDateFormat RELATIVITY_DATE_SLASH;

    private static String RELATIVITY_TIME_FORMAT;
    private static int RELATIVITY_TIME_FORMAT_LENGTH;
    private static SimpleDateFormat RELATIVITY_TIME;

    // Note that the java.text.SimpleDateFormat class cannot format sub
    // millisecond precision. Therefore we logically split timestamps
    // into a Datetime portion and a fraction portion.
    private static String DATETIME_FORMAT;
    private static int DATETIME_FORMAT_LENGTH;
    private static SimpleDateFormat DATETIME;
    // RCS - 12/28/2000 - DateTimestamp error fix
    private static String DATETIME_FORMAT2;
    private static int DATETIME_FORMAT2_LENGTH;
    private static SimpleDateFormat DATETIME2;
    // RCS - END
    private static int FRACTION_DIGITS;
    private static int NANOS_PER_FRACTION_UNIT;

    /**
     * It's slightly easier to read by putting all the initialization
     * here. It also reduces the dependency on initialization ordering.
     */
    static
    {
        RELATIVITY_DATE_FORMAT = "yyyy-MM-dd";
        RELATIVITY_DATE_FORMAT_LENGTH = RELATIVITY_DATE_FORMAT.length();
        RELATIVITY_DATE = new SimpleDateFormat(RELATIVITY_DATE_FORMAT);

        RELATIVITY_DATE_SLASH_FORMAT = "MM/dd/yyyy";
        RELATIVITY_DATE_SLASH_FORMAT_LENGTH = RELATIVITY_DATE_SLASH_FORMAT.length();
        RELATIVITY_DATE_SLASH = new SimpleDateFormat(RELATIVITY_DATE_SLASH_FORMAT);

        RELATIVITY_TIME_FORMAT = "HH:mm:ss";
        RELATIVITY_TIME_FORMAT_LENGTH = RELATIVITY_TIME_FORMAT.length();
        RELATIVITY_TIME = new SimpleDateFormat(RELATIVITY_TIME_FORMAT);

        DATETIME_FORMAT = "yyyy/MM/dd HH:mm:ss";
        DATETIME_FORMAT_LENGTH = DATETIME_FORMAT.length();
        DATETIME = new SimpleDateFormat(DATETIME_FORMAT);

        // RCS - 12/28/2000 - Fix datetime stamp problem
        DATETIME_FORMAT2 = "yyyy-MM-dd-HH:mm:ss";
        DATETIME_FORMAT2_LENGTH = DATETIME_FORMAT2.length();
        DATETIME2 = new SimpleDateFormat(DATETIME_FORMAT2);
        // RCS - END
        
        FRACTION_DIGITS = 6;       // ISO compliant
        NANOS_PER_FRACTION_UNIT = 1000;     // i.e. 10^(9 - FRACTION_DIGITS)
    }

    public int getInteger(int digits)
    {
        String string = get(digits + 1);

        //KAS020 if (string.trim().equals("")) return 0;
        
        if (string.trim().length() == 0) return 0; //KAS020
        
        boolean negative = (string.charAt(0) == '-');

        string = string.substring(1, string.length());
        string = Util.unpadLeft(string, Util.ZERO);

        if (string.trim().length() == 0) return 0;

        int field = Integer.parseInt(string);

        if (negative) field *= -1;

        return field;
    }
    public java.sql.Date readDate()
    {
        try
        {
            String string = get(RELATIVITY_DATE_FORMAT_LENGTH);

            if (string.trim().equals(""))
                return TemporalFunctions.ZERO_DATE;
                    
            if (string.charAt(2) == '/') 
                return new java.sql.Date(RELATIVITY_DATE_SLASH.parse(string).getTime());
              
            return new java.sql.Date(RELATIVITY_DATE.parse(string).getTime());
        }
        catch (Exception e)
        {
            Log.fatalException(e);
            // RCS - 02/13/01 - Fix for null dates causing problems
            //return null;    // keep the compiler happy
            return TemporalFunctions.ZERO_DATE;    // keep the compiler happy
            // RCS - END
        }
    }
    public int readInteger()
    {
        return getInteger(INTEGER_DIGITS);
    }
    public int readSmallint()
    {
        return getInteger(SMALLINT_DIGITS);
    }
    public java.sql.Time readTime()
    {
        try
        {
            String string = get(RELATIVITY_TIME_FORMAT_LENGTH);
            
            if (string.trim().equals(""))
                return TemporalFunctions.ZERO_TIME; 
                
            string = string.replace('.',':'); //KAS018
                
            return new java.sql.Time(RELATIVITY_TIME.parse(string).getTime());
        }
        catch (Exception e)
        {
            Log.fatalException(e);
            // RCS - 02/13/01 - Fix for null times causing problems
            //return null;    // keep the compiler happy
            return TemporalFunctions.ZERO_TIME;    // keep the compiler happy
            // RCS - END
        }
    }
    public java.sql.Timestamp readTimestamp()
    {
        String string = get(DATETIME_FORMAT_LENGTH).trim();
        

                
        // RCS - 12/29/2000 - If no string passed then no data returned.  make sure to read additional characters
        if (string.trim().equals(""))
        {
            //alka 02/01/01 To handle null exception if string is empty
            java.sql.Timestamp ts = new java.sql.Timestamp(0);
            get(1); // discard the period.
            string = get(FRACTION_DIGITS);
            ts.setNanos(0);
            //alka return null;
            return ts;
        }
            
        string = string.replace('.',':'); //KAS018

        try
        {
            java.util.Date date;
            try
            {
                date = DATETIME.parse(string);
            } catch (Exception e) {
                try {
                    if (string.length() == 26)
                    {
                        string = string.substring(0, 19);
                    }
                    
                    date = DATETIME2.parse(string);
                } catch (Exception e2) {
                    Log.information(this, "Exception 2:");
                    Log.fatalException(e);
                    Log.fatalException(e2);
                    // RCS - 02/13/01 - Fix for null timestamps causing problems
                    //return null;    // keep the compiler happy
                    return TemporalFunctions.ZERO_TIMESTAMP;    // keep the compiler happy
                    // RCS - END
                }
            }

            java.sql.Timestamp ts = new java.sql.Timestamp(date.getTime());

            get(1); // discard the period.
            string = get(FRACTION_DIGITS).trim();
            // RCS - 12/29/2000 -If no nanoseconds sent - set to 0
            if (string.equals(""))
            {
                string = "0";
            }
            // RCS - END
            int nanos = NANOS_PER_FRACTION_UNIT * Integer.parseInt(string);

            ts.setNanos(nanos);

            return ts;
        }
        catch (Exception e)
        {
            Log.fatalException(e);
            // RCS - 02/13/01 - Fix for null timestamps causing problems
            //return null;    // keep the compiler happy
            return TemporalFunctions.ZERO_TIMESTAMP;    // keep the compiler happy
            // RCS - END
        }
    }
    public Marshall writeDate(java.sql.Date field)
    {
        // RCS - 02/07/01 - Fix for null field
        //put(RELATIVITY_DATE.format(field));
        if (field == null)
        {
            //put(RELATIVITY_DATE.format(TemporalFunctions.ZERO_DATE));
            //                "yyyy-mm-dd"
            String spaces = "          ";
            put(spaces);
        }
        else
        {
            put(RELATIVITY_DATE.format(field));
        }
        // RCS - END
        return this;
    }
    public Marshall writeTime(java.sql.Time field)
    {
        // RCS - 02/07/01 - Fix for null field
        //put(RELATIVITY_TIME.format(field));
        if (field == null)
        {
            //put(RELATIVITY_TIME.format(TemporalFunctions.ZERO_TIME));
            //  "hh:mm:ss"
            put("        ");
        }
        else
        {
            put(RELATIVITY_TIME.format(field));
        }
        // RCS - END
        return this;
    }
    public Marshall writeTimestamp(java.sql.Timestamp field)
    {
        // RCS - 02/07/01 - Fix for null field
        //put(DATETIME.format(field));
        if (field == null)
        {
            //put(DATETIME.format(TemporalFunctions.ZERO_TIMESTAMP));
            //  "YYYY-MM-DD-hh:mm:ss.nnnnnn"
            put("                          ");
        }
        else
        {
            put(DATETIME.format(field));
        }
        // RCS - END
        put(".");
        String fract
            = Integer.toString(field.getNanos() / NANOS_PER_FRACTION_UNIT);
        put(Util.padLeft(fract, FRACTION_DIGITS, Util.ZERO));
        return this;
    }
}
