package com.ibm.ie.reeng.rt.common;


/**
 * This is a wrapper class around the {@link Trace} instance
 * which is used to perform logging. By default an instance of
 * {@link FullTrace} is used; however this behaviour can be overriden by
 * setting the system property &quot;trace.class&quot; to contain the
 * fully qualified name of a class which implements {@link Trace}.
 *
 * @see FullTrace
 * @see NullTrace
 * @see SimpleTrace
 */
public class Log
{
    /**
     * Only to be used through the static methods.
     */
    private Log() { }

    private static final String DEFAULT_TRACE_CLASS
        = "com.ibm.ie.reeng.rt.common.FullTrace";

    private static Trace trace;

    public static void setTrace(Trace trace) { Log.trace = trace; }

    static 
    {
        try
        {
            String traceClass = Config.instance().getString("trace.class");
            if (traceClass == null) traceClass = DEFAULT_TRACE_CLASS;
            Class c = Class.forName(traceClass); 
            setTrace((Trace)c.newInstance());
        }
        catch (Exception e)
        {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private static final String eol
        = System.getProperty("line.separator");
    public static void outputln(String text)
    {
        trace.output(text);
        trace.output(eol);
    }

    public static void output(String text)
    {
        trace.output(text);
    }

    public static void information(Object source, String text)
    {
        trace.information(source, text);
    }

    public static void warning(Object source, String text)
    {
        trace.warning(source, text);
    }

    public static void error(Object source, String text)
    {
        trace.error(source, text);
    }

    public static void fatalError(Object source, String text)
    {
        trace.fatalError(source, text);
    }

    public static void exception(Exception e)
    {
        trace.exception(e);
    }

    public static void fatalException(Exception e)
    {
        trace.fatalException(e);
    }
}
