package com.ibm.ie.reeng.rt.common;

//import java.io.*;
import java.io.StringWriter;
import java.io.PrintWriter;
import java.io.BufferedReader;
import java.io.StringReader;


/**
 * This class is provided as a debugging utility. Invoking
 * {@link Location#log()} causes the stack trace of the current thread
 * to be written to the {@link Log}.
 */
public class Location
{
    public static void logStack()
    {
        log(true, 1);
    }

    public static void log()
    {
        log(false, 1);
    }

    public static void logCaller()
    {
        log(false, 2);
    }

    private static void log(boolean entireStack, int skipFrames)
    {
        try
        {
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);

            // Get and store a trace of the stack.
            Throwable location = new Throwable();
            location.printStackTrace(printWriter);

            // Use BufferedReader to read the trace line by line.
            BufferedReader reader = new BufferedReader(new
                StringReader(writer.getBuffer().toString()));

            String line;

            // Throw away all lines up to the callers frame. Also work
            // out where to chop the lines.
            while ((line = reader.readLine()) != null)
            {
                if (line.indexOf("transmute.runtime.Location.log") != -1)
                    break;
            }

            // throw away some lines.
            while (skipFrames-- > 0) reader.readLine();

            if (entireStack)
            {
                Log.information("Location", "stack trace:");
                // Print out the remaining lines.
                while ((line = reader.readLine()) != null)
                {
                    line = line.trim();
                    Log.information("Location", line);
                }
            }
            else
            {
                // Print out the next line.
                line = reader.readLine().trim();
                Log.information("Location", line);
            }
        }
        catch (Exception e)
        {
            Log.fatalException(e);
        }
    }

    public static void main(String[] args)
    {
        log(); // Test.
Thread.currentThread().dumpStack();
        logStack(); // Test.
    }
}
