package com.ibm.ie.reeng.rt.common;


/**
 * This class is used to represent the attributes of Hps GUI events. It
 * is included in the runtime (rather than using a generated class)
 * because of the heavy dependence of many of the other runtime classes.
 */
public class HpsEventView extends View
{
    public HpsEventView() { clear(); }

    public int eventType;
    public String eventName;
    public String eventSource;
    public String eventQualifier;
    public String eventView;
    public String eventParam;

    public Object clone()
        throws CloneNotSupportedException
    {
        Object o=null;
        
        try
        {
            o=super.clone();
        }
        catch (CloneNotSupportedException e) {}

        return o;
    }


    /**
     * We don't fully support WINDOW_RETCODE yet; this is all we know
     * about it so far.
     */
    public String getWindowRetcode()
    {
        if (eventName.equals("HPS_LB_OUTRANGE"))
        {
            return "OUT OF RANGE " + eventSource;
        }
        return eventSource;
    }

    public void dump()
    {
        Log.outputln("WINDOW EVENT:");
        Log.outputln(" eventType = " + HpsEventType.toString(eventType));
        Log.outputln(" eventName = " + eventName);
        Log.outputln(" eventSource = " + eventSource);
        Log.outputln(" eventQualifier = " + eventQualifier);
        Log.outputln(" eventView = " + eventView);
        Log.outputln(" eventParam = " + eventParam);
        Log.outputln(" WINDOW_RETCODE = " + getWindowRetcode());
    }

    public final void clear()
    {
        eventType = 0;
        eventName = "";
        eventSource = "";
        eventQualifier = "";
        eventView = "";
        eventParam = "";
    }

    public void writeMembersTo(Marshall m)
    {
        m.writeSmallint(eventType);
        m.writeChar(eventName, 30);
        m.writeChar(eventSource, 30);
        m.writeChar(eventQualifier, 30);
        m.writeChar(eventView, 30);
        m.writeChar(eventParam, 256);
    }

    public void readMembersFrom(Marshall m)
    {
        eventType = m.readSmallint();
        eventName = m.readChar(30);
        eventSource = m.readChar(30);
        eventQualifier = m.readChar(30);
        eventView = m.readChar(30);
        eventParam = m.readChar(256);
    }

    public void copyInto(HpsEventView v)
    {
        eventType=v.eventType;
        eventName=v.eventName;
        eventSource=v.eventSource;
        eventQualifier=v.eventQualifier;
        eventView=v.eventView;
        eventParam=v.eventParam;
    }
}
