package com.ibm.ie.reeng.rt.common;

/**
 * <code>DisplayString</code>s are used by {@link LookupSet}s and
 * subclasses to associate user readable text with the values of a set.
 */
public class DisplayString
{
    private Object value;
    private String display;

    public Object getValue() { return value; }


    public String getString() { return display; }


    public DisplayString(Object value, String display)
    {
        this.value = value;
        this.display = display;
    }


    public DisplayString(double value, String display)
    {
        this(new Double(value), display);
    }


    public DisplayString(int value, String display)
    {
        this(new Integer(value), display);
    }
}
