package com.ibm.ie.reeng.rt.common;


/**
 * This class provides a global interface to constant configuration
 * information.
 * <p>
 * Since this information has different sources depending on the Java
 * environment; this class actually delegates the lookup.  The class is
 * implemented using the singleton pattern.
 * <p>
 * Note this class does not use tranmsute.runtime.Log as doing so
 * introduces a circular dependency.
 * <p>
 * Note also that {@link #setSource} needs to be called early; usually
 * this is done by a static initializer of some base class particular to
 * a particular environment.
 */
public class Config
{
    public interface Source
    {
        public String getString(String key);
        public boolean getBoolean(String key);
        public int getInt(String key);
        public Integer getInteger(String key);
    }

    private class SystemProperties implements Source
    {
        public String getString(String key)
        {
            return System.getProperty(key);
        }

        public boolean getBoolean(String key)
        {
            return Boolean.getBoolean(key);
        }

        public int getInt(String key)
        {
            Integer i = getInteger(key);

            if (i != null) return i.intValue();

            System.out.println("Cofig: ERROR " + key
                + " should be manditory");
            return -1;
        }

        public Integer getInteger(String key)
        {
            return Integer.getInteger(key);
        }
    }

    private static Config instance;

    public static Config instance()
    {
        if (instance == null)
        {
            instance = new Config();
        }
        return instance;
    }

    private static Source source;

    public static void setSource(Source source)
    {
        Config.source = source;
    }


    private Config()
    {
        if (source == null)
        {
            System.err.println("Error: no configuration source "
                + "explicitly set. Using System.properties.");
            source = new SystemProperties();
            java.io.InputStream in = ClassLoader.getSystemResourceAsStream("runtime.properties");
            try
            {
                System.getProperties().load(in);
            }
            catch (Exception e)
            {
                e.printStackTrace();
            }
        }
    }

    public String getString(String key)
    {
        return source.getString(key);
    }

    public boolean getBoolean(String key)
    {
        return source.getBoolean(key);
    }

    public int getInt(String key)
    {
        return source.getInt(key);
    }

    public Integer getInteger(String key)
    {
        return source.getInteger(key);
    }

    public String getProperty(String key, String defaultVal)
    {
        String s=getString(key);
        if (s==null)
            return defaultVal;
        else
            return s;
    }
}
